
#include <net/netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <sys/types.h>

#include "java_net_Socket.h"
#include "java_net_SocketImpl.h"
#include "java_net_PlainSocketImpl.h"
#include "java_net_ServerSocket.h"
#include "java_net_SocketInputStream.h"
#include "java_net_SocketOutputStream.h"
#include "java_net_InetAddress.h"
#include "java_net_DatagramPacket.h"
#include "java_net_DatagramSocket.h"
#include "java_io_FileDescriptor.h"
#include "fd_md.h"
#include "bool.h"

#define JAVANETPKG 	"java/net/"

// Right now DR7 doesn't let us bind to "any address"
// so ANY_ADDRESS must either be 0 to accept outside connections
// or 127.0.0.1 (ie 0x7F000001) to accept local connections. Paul.

#define ANY_ADDRESS		0x00000000

/*
 * Support originally from fd_md.c
 */

int sysRecvFD(Classjava_io_FileDescriptor *fdobj, char *buf, int nbytes, 
	      int flags)
{
    return  recv(fdobj->fd-1, buf, nbytes, flags);
}

int sysSendFD(Classjava_io_FileDescriptor *fdobj, char *buf, int nbytes, 
	      int flags)
{
   return send(fdobj->fd-1, buf, nbytes, flags);
}

void sysSocketCloseFD(Classjava_io_FileDescriptor *fdobj) {
    if (fdobj->fd-1 >= 0) {
        closesocket(fdobj->fd-1);
	fdobj->fd = -1;
    }
}

/*
 * InetAddress
 */

struct Hjava_lang_String *
java_net_InetAddress_getLocalHostName(Hjava_net_InetAddress *Hthis)
{
    char hostname[256];

    if (gethostname(hostname, sizeof hostname) == -1) {
	strcpy(hostname, "localhost");
    }
    return makeJavaString(hostname, strlen(hostname));
}

void 
java_net_InetAddress_makeAnyLocalAddress(Hjava_net_InetAddress *Hthis,
					 Hjava_net_InetAddress *Haddr)
{
    Classjava_net_InetAddress *addr;

    if (Haddr == NULL) {
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return;
    }
    addr = unhand(Haddr);

// This should default to the local ethernet/PPP port. Paul.

    addr->address = ANY_ADDRESS;
    addr->family = AF_INET;
}

long 
java_net_InetAddress_getInetFamily(struct Hjava_net_InetAddress *dummy)
{
    return AF_INET;
}

/*
 * PlainSocketImpl
 */

void 
java_net_PlainSocketImpl_socketCreate(Hjava_net_PlainSocketImpl *Hthis,
				      long stream)
{
    Classjava_net_PlainSocketImpl *this = unhand(Hthis);
    Classjava_io_FileDescriptor *fdptr = unhand(this->fd);
    int fd;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }

    fd = socket(AF_INET, stream ? SOCK_STREAM : SOCK_DGRAM, 0);
    if (fd == -1) {
		SignalError(0, JAVANETPKG "SocketException", "Error creating socket");
	return;
    }
    fdptr->fd = fd + 1;

    /* make the socket address immediatly available for reuse */
    setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, "yes", 4);
}

void 
java_net_PlainSocketImpl_socketConnect(Hjava_net_PlainSocketImpl *Hthis,
				       Hjava_net_InetAddress *Haddr,
				       long port)
{
    Classjava_net_PlainSocketImpl *this = unhand(Hthis);
    Classjava_net_InetAddress *addr;
    struct sockaddr_in him;
    Classjava_io_FileDescriptor *fdptr = unhand(this->fd);
    int fd;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }

    fd = fdptr->fd - 1;

    if (Haddr == NULL) {
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return;
    }
    addr = unhand(Haddr);

    /* connect */
    memset(&him, 0, sizeof him);
    him.sin_port = htons((short)port);
    him.sin_addr.s_addr = (unsigned long)htonl(addr->address);
    him.sin_family = addr->family;

    if (connect(fd, (struct sockaddr *)&him, sizeof him) < 0) {
	struct execenv *ee = EE();
	if (ee && exceptionOccurred(ee)) {
	    return;
	}
	SignalError(0, JAVANETPKG "SocketException", "connect");
	return;
    }

    /* set the remote peer address and port */
    this->address = Haddr;
    this->port = port;

    /* we need to intialize the local port field
       If bind was called previously to the connect (by the client) then
       localport field will already be initialized 
    */
    if (this->localport == 0) {
	/* Now that we're a connected socket, let's extract the port number
	 * that the system chose for us and store it in the Socket object. 
  	 */
	int len = sizeof(him);
	if (getsockname(fd, (struct sockaddr *)&him, &len) == -1) {
	    SignalError(0, JAVANETPKG "SocketException", "getsockname");
	    return;
	}
	this->localport = ntohs(him.sin_port);
    }
}

void 
java_net_PlainSocketImpl_socketBind(Hjava_net_PlainSocketImpl *Hthis,
				    Hjava_net_InetAddress *Haddr,
				    long port)
{
    Classjava_net_PlainSocketImpl *this = unhand(Hthis);
    Classjava_net_InetAddress *addr;
    struct sockaddr_in him;
    Classjava_io_FileDescriptor *fdptr = unhand(this->fd);
    int fd;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }

    fd = fdptr->fd - 1;

    if (Haddr == NULL) {
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return;
    }
    addr = unhand(Haddr);

    /* bind */
    memset(&him, 0, sizeof him);
    him.sin_port = htons((short)port);
    him.sin_addr.s_addr = (unsigned long)htonl(addr->address);
    him.sin_family = addr->family;

    if (bind(fd, (struct sockaddr *)&him, sizeof him) == -1) {
	SignalError(0, JAVANETPKG "SocketException", "bind");
	return;
    }

    /* set the address */
    this->address = Haddr;

    /* intialize the local port */
    if (port == 0) {
	/* Now that we're a connected socket, let's extract the port number
	 * that the system chose for us and store it in the Socket object. 
  	 */
	int len = sizeof(him);
	if (getsockname(fd, (struct sockaddr *)&him, &len) == -1) {
	    SignalError(0, JAVANETPKG "SocketException", "getsockname");
	    return;
	}
	this->localport = ntohs(him.sin_port);
    } else {
	this->localport = port;
    }
}

void 
java_net_PlainSocketImpl_socketListen(Hjava_net_PlainSocketImpl *Hthis,
				      long count)
{
    Classjava_net_PlainSocketImpl *this = unhand(Hthis);
    Classjava_io_FileDescriptor *fdptr = unhand(this->fd);
    int fd;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }

    fd = fdptr->fd - 1;

    if (listen(fd, count) == -1) {
	SignalError(0, JAVANETPKG "SocketException", "listen");
    }
}

void 
java_net_PlainSocketImpl_socketAccept(Hjava_net_PlainSocketImpl *Hthis,
				      Hjava_net_SocketImpl *Hs)
{
    Classjava_net_PlainSocketImpl *this = unhand(Hthis);
    Classjava_io_FileDescriptor *fdptr = unhand(this->fd);
    int infd;
    Classjava_net_SocketImpl *sptr;
    Classjava_io_FileDescriptor *sptr_fdptr;
    Classjava_net_InetAddress *addr;
    struct sockaddr_in him;
    int len = sizeof(him);
    int fd;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }
    infd = fdptr->fd - 1;

    if (Hs == NULL) {
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return;
    }
    sptr = unhand(Hs);
    sptr_fdptr = unhand(sptr->fd);

    if ((sptr->address == NULL) || (sptr_fdptr == NULL)){
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return;
    }
    addr = unhand(sptr->address);

    fd = accept(infd, (struct sockaddr *)&him, &len);
    if (fd < 0) {
	SignalError(0, JAVANETPKG "SocketException", "accept");
	return;
    }
    sptr_fdptr->fd = fd + 1;
    sptr->port = ntohs(him.sin_port);
    addr->family = him.sin_family;
    addr->address = ntohl(him.sin_addr.s_addr);
    /* also fill up the local port information */
    sptr->localport = this->localport;
}

long
java_net_PlainSocketImpl_socketAvailable(struct Hjava_net_PlainSocketImpl *Hthis)
{
    int ret = 0;
    Classjava_net_PlainSocketImpl *this = unhand(Hthis);
    Classjava_io_FileDescriptor *fdptr = unhand(this->fd);
    int fd;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return ret;
    }

    fd = fdptr->fd - 1;

    if (fd <= 0)
// no idea how to port this to BeOS in DR7. Paul.
//	|| ioctlsocket(fd, FIONREAD, &ret) < 0)
    {
	SignalError(0, JAVANETPKG "SocketException", "available");
    }
    return ret;
}

void 
java_net_PlainSocketImpl_socketClose(struct Hjava_net_PlainSocketImpl *Hthis)
{
    Classjava_net_PlainSocketImpl *thisptr = unhand(Hthis);
    Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }

    sysSocketCloseFD(fdptr);
}

/*
 * SocketInputStream
 */

long 
java_net_SocketInputStream_socketRead(Hjava_net_SocketInputStream *Hthis, 
				      HArrayOfByte *Hdata, long off, long len)
{
    Classjava_net_SocketInputStream *this = unhand(Hthis);
    Classjava_io_FileDescriptor *fdptr = unhand(this->fd);
    char *data, *tmpbuf;
    int datalen, n;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return 0;
    }

    if (Hdata == NULL) {
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return 0;
    }
    data = unhand(Hdata)->body;
    datalen = obj_length(Hdata);

    if (len < 0 || off < 0 || len + off > datalen) {
        SignalError(0, JAVAPKG "ArrayIndexOutOfBoundsException", 0);
        return 0;
    }

    /* 
     * The use of a temporary buffer to hold the recv'd data is a workaround
     * for a threads problem under Win32. The problem is that the buffer can
     * continue to be written to even after the thread has been suspended
     * while in recv, and this can cause the garbage collector to fail. There
     * is probably a more efficient way of creating tmpbuf than having to
     * reallocate it each time this function is called.
     */

    if ((tmpbuf = malloc(len)) == NULL) {
	SignalError(0, JAVAPKG "OutOfMemoryError", 0);
	return 0;
    }
    n = sysRecvFD(fdptr, tmpbuf, len, 0);
    if (n == -1) {
        struct execenv *ee = EE();
        if (!(ee && exceptionOccurred(ee))) {
            SignalError(0, "java/io/IOException", "recv");
        }
    } else {
	memcpy(data + off, tmpbuf, n);
    }
    free(tmpbuf);

    /* AVH: this is bogus but it stops the pointer from being gc'd */
    if (data == NULL) {
        SignalError(0, JAVAPKG "NullPointerException", 0);
    }
    return n;
}

/*
 * SocketOutputStream
 */

void
java_net_SocketOutputStream_socketWrite(Hjava_net_SocketOutputStream *Hthis,
					HArrayOfByte *Hdata, long off, long len)
{
    Classjava_net_SocketOutputStream *this = unhand(Hthis);
    Classjava_io_FileDescriptor *fdptr = unhand(this->fd);
    char *data;
    int datalen, n;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }

    if (Hdata == NULL) {
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return;
    }
    data = unhand(Hdata)->body;
    datalen = obj_length(Hdata);

    if (len < 0 || off < 0 || len + off > datalen) {
        SignalError(0, JAVAPKG "ArrayIndexOutOfBoundsException", 0);
        return;
    }

    while (len > 0) {
	n = sysSendFD(fdptr, data + off, len, 0);
	if (n == -1) {
	    struct execenv *ee = EE();
	    if (!(ee && exceptionOccurred(ee))) {
		SignalError(0, "java/io/IOException", "send");
	    }
	    break;
	}
        off += n;
	len -= n;
    }
}

/*
 * Find an internet address for a given hostname.  Note that this
 * code only works for addresses of type INET.  Furthurmore while
 * the APIs are prepared for expansion of IP addresses to 64 bits,
 * the implementaiton, particularly around the translation of
 * "xxx.xxx.xxx.xxx" to an address, will need some work.
 */
HArrayOfByte *
java_net_InetAddress_lookupHostAddr(Hjava_net_InetAddress *dummy, HString *host)
{
    char hostname[256];
    struct hostent *hp;
    HArrayOfByte *ret;

    if (host == 0) {
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return 0;
    }

    javaString2CString(host, hostname, sizeof (hostname));
    if (isdigit(hostname[0])) {
	/*
	 * This is totally bogus. inet_addr returns a 4-byte value
	 * by definition, thereby making the transition to 64-bit IP
	 * addresses much harder.  It should instead write into a
	 * user-supplied "struct in_addr"!  We'll deal with this
	 * later when 64-bit IP addresses are more of a reality -
	 * csw.
	 */
	unsigned long iaddr = inet_addr(hostname);
	if ((int)iaddr == -1) {
	    SignalError(0, JAVANETPKG "UnknownHostException", hostname);
	    return 0;
	}
	ret = (HArrayOfByte *) ArrayAlloc(T_BYTE, sizeof(iaddr));
	if (ret == 0)
	    return 0;
	memcpy(unhand(ret)->body, (char *)&iaddr, sizeof(iaddr));
    } else if ((hp = gethostbyname(hostname)) != NULL) {
	ret = (HArrayOfByte *) ArrayAlloc(T_BYTE, sizeof(struct in_addr));
	if (ret == 0)
	    return 0;
	memcpy(unhand(ret)->body, hp->h_addr, sizeof(struct in_addr));
    } else {
	SignalError(0, JAVANETPKG "UnknownHostException", hostname);
	return 0;
    }
    return (HArrayOfByte *) ret;
}


/*
 * Find an internet address for a given hostname.  Not this this
 * code only works for addresses of type INET.  Furthurmore while
 * the APIs are prepared for expansion of IP addresses to 64 bits,
 * the implementaiton, particularly around the translation of
 * "xxx.xxx.xxx.xxx" to an address, will need some work.
 */
HArrayOfArray *
java_net_InetAddress_lookupAllHostAddr(Hjava_net_InetAddress *dummy, HString *host)
{
    char hostname[256];
    struct hostent *hp;
    HArrayOfArray *ret;

    if (host == 0) {
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return 0;
    }

    javaString2CString(host, hostname, sizeof (hostname));
    if (isdigit(hostname[0])) {
	SignalError(0, JAVANETPKG "UnknownHostException", hostname);
	return 0;
    } else if ((hp = gethostbyname(hostname)) != NULL) {
	struct in_addr **addrp = (struct in_addr **) hp->h_addr_list;
	int i = 0;

	while (*addrp != (struct in_addr *) 0) {
	    i++;
	    addrp++;
	}

	ret = (HArrayOfArray *) ArrayAlloc(T_CLASS, i);
	if (ret == 0)
	    return 0;
	memset((char *) unhand(ret), 0, sizearray(T_CLASS, i));
	unhand(ret)->body[i] = (HObject*)FindClass(0, "[B", TRUE);

	addrp = (struct in_addr **) hp->h_addr_list;
	i = 0;
	while (*addrp != (struct in_addr *) 0) {
	    HArrayOfByte *barray = (HArrayOfByte *)
		ArrayAlloc(T_BYTE, sizeof(struct in_addr));
	    if (barray == 0) 
		return 0;
	    memcpy(unhand(barray)->body, (char *) (*addrp), sizeof(struct in_addr));
	    unhand(ret)->body[i] = (Hjava_lang_Object *) barray;
	    addrp++;
	    i++;
	}
	return ret;
    } else {
	SignalError(0, JAVANETPKG "UnknownHostException", hostname);
	return 0;
    }
}

/*
 * Find a hostname for a given internet address.  Only the first hostname is returned.
 */

// added 'cos it's not in netdb.h

extern struct hostent * gethostbyaddr(const char *, int, int);

HString *
java_net_InetAddress_getHostByAddr(Hjava_net_InetAddress *dummy, long addr)
{
    struct hostent *hp;

    /*
     * We are careful here to use the reentrant version of
     * gethostbyname because at the Java level this routine is not
     * protected by any synchronization.
     */
    addr = htonl(addr);
    hp = gethostbyaddr((char *)&addr, sizeof(addr), AF_INET);
    if (hp == NULL) {
	SignalError(0, JAVANETPKG "UnknownHostException", NULL);
	return 0;
    }
    return makeJavaString(hp->h_name, strlen(hp->h_name));
}

/* Datagram support */
void java_net_DatagramSocket_datagramSocketCreate(struct Hjava_net_DatagramSocket *this)
{
    Classjava_net_DatagramSocket *thisptr = unhand(this);
    Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);
    int fd;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }

    fd =  socket(AF_INET, SOCK_DGRAM, 0);
    if (fd == -1) {
	SignalError(0, JAVANETPKG "SocketException", "socket");
	return;
    }

    fdptr->fd = fd + 1;

    /* make the socket address immediatly available for reuse */
    setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, "yes", 4);

}

void java_net_DatagramSocket_datagramSocketClose(struct Hjava_net_DatagramSocket *this)
{
    Classjava_net_DatagramSocket *thisptr = unhand(this);
    Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }

    sysSocketCloseFD(fdptr);
}

long java_net_DatagramSocket_datagramSocketBind(struct Hjava_net_DatagramSocket *this, long port)
{
    Classjava_net_DatagramSocket *thisptr = unhand(this);
    struct sockaddr_in lcladdr;
    int lcladdrlen= sizeof(lcladdr);
    Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return -1;
    }

    /* bind - pick a port number for local addr*/
    memset((char *) &lcladdr, 0, sizeof(lcladdr));
    lcladdr.sin_family      = AF_INET;
    lcladdr.sin_port        = htons((short)port);
    lcladdr.sin_addr.s_addr = ANY_ADDRESS;

    if (bind(fdptr->fd - 1, (struct sockaddr *)&lcladdr, sizeof(lcladdr)) == -1) {
	SignalError(0, JAVANETPKG "SocketException", "bind");
	return -1;
    }

    /* find what port system picked for us - obviously brain dead interface,
       should have told me in the bind call itself */
    if (getsockname(fdptr->fd - 1, (struct sockaddr *)&lcladdr, &lcladdrlen) == -1) {
	SignalError(0, JAVANETPKG "SocketException", "getsockname");
	return -1;
    }
    thisptr->localPort = ntohs(lcladdr.sin_port);
    return thisptr->localPort;
}

void
java_net_DatagramSocket_datagramSocketSend(struct Hjava_net_DatagramSocket *this,
struct Hjava_net_DatagramPacket *packet)
{
    Classjava_net_DatagramSocket *thisptr = unhand(this);
    Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);
    Classjava_net_DatagramPacket *packetptr = unhand(packet);
    Classjava_net_InetAddress *addrptr = unhand(packetptr->address);
    HArrayOfByte *data = packetptr->buf;
    char *dataptr;
    int datalen;
    long n;
    struct sockaddr_in rmtaddr;

    if (fdptr == 0) {
	SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
	return;
    }

    if (data == 0) {
	SignalError(0, JAVAPKG "NullPointerException", 0);
	return;
    }

    dataptr = unhand(data)->body;
    datalen = packetptr->length;
    rmtaddr.sin_port = htons((short)(packetptr->port));
    rmtaddr.sin_addr.s_addr = htonl(addrptr->address);
    rmtaddr.sin_family = addrptr->family;

    n = sendto(fdptr->fd - 1, dataptr, datalen, 0, (struct sockaddr *)&rmtaddr, sizeof(rmtaddr));
    if (n == -1) {
      struct execenv *ee = EE();
      if (!(ee && exceptionOccurred(ee))) {
		SignalError(0, "java/io/IOException", "syssentto");
      }
      packetptr->length = 0;
    }

    packetptr->length = n;
    return;
}

long
java_net_DatagramSocket_datagramSocketPeek(struct Hjava_net_DatagramSocket *this, struct Hjava_net_InetAddress *in)
{
    Classjava_net_DatagramSocket *thisptr = unhand(this);
    Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);
    Classjava_net_InetAddress *addrptr = unhand(in);
    int n;
    struct sockaddr_in remote_addr;
    int remote_addrsize = sizeof (remote_addr);
    char buf[1];

    if (addrptr==0 || fdptr==0) {
        SignalError(0, JAVAPKG "NullPointerException", 0);
        return 0;
    }

/* This line was:
    n = recvfrom(fdptr->fd - 1, buf, 1, MSG_PEEK, 
		 (struct sockaddr *)&remote_addr, &remote_addrsize);
   but BeOS doesn't seem to have the MSG_PEEK option, just MSG_OOB
   MSG_PEEK is actually equal to 0x2, so I'm trying it anyway,
   we'll see what happens. Maybe DR8 will solve things. Paul.
*/
    n = recvfrom(fdptr->fd - 1, buf, 1, 0x2, 
		 (struct sockaddr *)&remote_addr, &remote_addrsize);

    if (n==-1) {
        SignalError(0, "java/io/IOException", 0);
        return 0;
    }
 
    addrptr->family = remote_addr.sin_family;
    addrptr->address = ntohl(remote_addr.sin_addr.s_addr);

    /* return port */
    return ntohs(remote_addr.sin_port);
}


void
java_net_DatagramSocket_datagramSocketReceive(struct Hjava_net_DatagramSocket *this, struct Hjava_net_DatagramPacket *packet)
{
    Classjava_net_DatagramSocket *thisptr = unhand(this);
    Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);
    Classjava_net_DatagramPacket *packetptr = unhand(packet);
    Classjava_net_InetAddress *addrptr=0;
    HArrayOfByte *data = packetptr->buf;
    char *dataptr;
    int datalen;
    long n;
    struct sockaddr_in remote_addr;
    int remote_addrsize = sizeof (remote_addr);

    packetptr->address = (Hjava_net_InetAddress *) execute_java_constructor(EE(),
				  "java/net/InetAddress",
				  (ClassClass *) 0, "()"); 

    if (data == 0 || (packetptr->address==0) || fdptr==0) {
        SignalError(0, JAVAPKG "NullPointerException", 0);
        return;
    }
    addrptr = unhand(packetptr->address);

    dataptr = unhand(data)->body;
    datalen = packetptr->length;
 
    while (1) {
      n = recvfrom(fdptr->fd - 1, dataptr, datalen, 0, 
		 (struct sockaddr *)&remote_addr, &remote_addrsize);
      if (n!=-1) break;
    }
    if (n == -1) {
        struct execenv *ee = EE();
        if (!(ee && exceptionOccurred(ee))) {
            SignalError(0, "java/io/IOException", "sysrecvfrom");
        }
	packetptr->length = 0;
    } else { /* success */
      packetptr->port = ntohs(remote_addr.sin_port);
      packetptr->length = n;
      addrptr->family = remote_addr.sin_family;
      addrptr->address = ntohl(remote_addr.sin_addr.s_addr);
    }

    return;
}
