
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/param.h>
#include <pwd.h>

#include "timeval.h"
#include "sys_api.h"
#include "oobj.h"
#include "java_lang_System.h"

/*
 * This routine initializes the system properties with
 * all the system defined properties.
 *
 * REMIND: We need to obtain some of these values in a more
 * organized way.
 */

#define PUTPROP(props, key, val) \
    execute_java_dynamic_method(0, (HObject *)(props), \
				"put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;",\
				makeJavaString((key), strlen(key)),\
				makeJavaString((val), strlen(val)))

char **user_props = 0;

struct Hjava_util_Properties *
java_lang_System_initProperties(struct Hjava_lang_System *this, 
				struct Hjava_util_Properties *props) 
{
    char *v;
    char buf[MAXPATHLEN];	/* Needs to hold cwd */
    struct passwd *pwent;
    int uid;

    /* java properties */
    PUTPROP(props, "java.version", RELEASE);
    PUTPROP(props, "java.vendor", "Sun Microsystems Inc.");
    PUTPROP(props, "java.vendor.url", "http://www.sun.com/");
    v = getenv("JAVA_HOME");
    PUTPROP(props, "java.home", v ? v : "/usr/local/java");
    if (jio_snprintf(buf, MAXPATHLEN,
		 "%d.%d", JAVA_VERSION, JAVA_MINOR_VERSION) == -1) {
	SignalError(0, JAVAPKG "InternalError", "invalid version number");
    }
    PUTPROP(props, "java.class.version", buf);
    v = getenv("CLASSPATH");
    PUTPROP(props, "java.class.path", v ? v : "");

    /* os properties */
    PUTPROP(props, "os.name", "BeOS");
    PUTPROP(props, "os.version", "1.1dr7.1");
    PUTPROP(props, "os.arch", "PPC");

    /* file system properties */
    PUTPROP(props, "file.separator", "/");
    PUTPROP(props, "path.separator", ":");
    PUTPROP(props, "line.separator", "\n");

    /* user properties */
    /* pwent = getpwuid(getuid()); */
    PUTPROP(props, "user.name", "?");
    PUTPROP(props, "user.home", "?");

    getcwd(buf, sizeof(buf));
    PUTPROP(props, "user.dir", buf);

    /* Java compiler */
    v = getenv("JAVA_COMPILER");
    if (v != NULL) 
	PUTPROP(props, "java.compiler", v ? v : "");

    /* user defined properties, set by main */
    if (user_props != 0) {
	int i;
	for (i = 0 ; user_props[i] && user_props[i+1] ; i += 2) {
	    PUTPROP(props, user_props[i], user_props[i+1]);
	}
    }
    return props;
}
