
#include <stdlib.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <errno.h>
 
#include "oobj.h"
#include "tree.h"
#include "interpreter.h"
#include "javaString.h"
#include "typecodes.h"
#include "sys_api.h"
#include "monitor.h"
#include "monitor_md.h"

#include "java_io_FileDescriptor.h"
#include "java_io_FileInputStream.h"
#include "java_lang_System.h"
#include "java_lang_Runtime.h"
#include "java_lang_Process.h"
#include "java_lang_BeOSProcess.h"

static long team_exit_value = 0;


void java_lang_BeOSProcess_forkexec(Hjava_lang_BeOSProcess *this,
									HArrayOfString *cmdarray,
									HArrayOfString *envp)
{
    int pid = 0;
    int fdin[2], fdout[2], fderr[2], len;
    Classjava_lang_BeOSProcess *thisptr = unhand(this);
    Classjava_io_FileDescriptor *infdptr = unhand(thisptr->stdin_fd);
    Classjava_io_FileDescriptor *outfdptr = unhand(thisptr->stdout_fd);
    Classjava_io_FileDescriptor *errfdptr = unhand(thisptr->stderr_fd);
	char **envstr=0, *envpolo[1];
    char *cmdstr[200];

    len = obj_length(cmdarray);
    if (len == 0 || len > 200) {
		SignalError(0, JAVAPKG "IllegalArgumentException", 0);
		return;
    }
#define BODYOF(h)   unhand(h)->body
    cmdstr[len] = 0;
    while (len--) {
		cmdstr[len] = allocCString(BODYOF(cmdarray)[len]);
    }

    if (envp) len = obj_length (envp);
    if (!envp || len == 0) {
		envpolo[0] = 0;
    } else {
		int i;
	
	 	envstr = (char **)calloc((len+1), sizeof(char *));
	 	if (envstr == 0) {
	 	    SignalError(0, JAVAPKG "IllegalArgumentException", 0);
	 	    return;
	 	}
	 	envstr[len] = 0;
	 	for (i=0; i<len; ++i) {
	 	    envstr[i] = makeCString(BODYOF(envp)[i]);
	 	}
    }

    pipe(fdout);  /* stdout */
    pipe(fderr);  /* stderr */

	
	dup2(1, OPEN_MAX-1);
	dup2(fdout[1], 1);

	dup2(2, OPEN_MAX-2);
	dup2(fderr[1], 2);

    if (!envp || len == 0) {
		pid = load_posix(cmdstr[0], cmdstr, envpolo);
    } else {
		pid = load_posix(cmdstr[0], cmdstr, envstr);
	}
	
	dup2(OPEN_MAX-1, 1);
	close(OPEN_MAX-1);

	dup2(OPEN_MAX-2, 2);
	close(OPEN_MAX-2);

	if (wait_for_thread (pid, &team_exit_value) < 0) team_exit_value = -1;

    (void) close (fdout[1]);
    (void) close (fderr[1]);

	infdptr->fd = 0;
	outfdptr->fd = fdout[0]+1;
	errfdptr->fd = 0;
	
    thisptr->pid = pid;

}




Hjava_lang_Process *
java_lang_Runtime_execInternal(Hjava_lang_Runtime *this, 
			       HArrayOfString *cmdarray, HArrayOfString *envp) 
{
    Hjava_lang_Process *proc = 0;

    if (cmdarray == 0) {
		SignalError(0, JAVAPKG "NullPointerException", 0);
		return 0;
    }
	
    /*
	We need a way to know which subclass of Process we want to create.
    */

    proc = (Hjava_lang_Process *) execute_java_constructor(EE(),
				  JAVAPKG "BeOSProcess",
				  (ClassClass *) 0, 
				  "([Ljava/lang/String;[Ljava/lang/String;)", 
				  cmdarray, envp);
    return proc;
}

void
java_lang_BeOSProcess_destroy(Hjava_lang_BeOSProcess *this)
{
    kill_thread(unhand(this)->pid);
}

void
java_lang_BeOSProcess_close(Hjava_lang_BeOSProcess *this)
{
    kill_thread(unhand(this)->pid);
}

long
java_lang_BeOSProcess_waitFor(Hjava_lang_BeOSProcess *this)
{
	return team_exit_value;
}

long
java_lang_BeOSProcess_exitValue(Hjava_lang_BeOSProcess *this)
{
	return team_exit_value;
}

