
/*
 * Machine dependent path name and file name manipulation code
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include "path.h"	/* for cpe_t */
#include "zip.h"	/* for zip_t */

cpe_t **
sysGetClassPath(void)
{
    static cpe_t **classpath;

    if (classpath == 0) {
	char *cps, *s;
	int ncpe = 1;
	cpe_t **cpp;
	if ((cps = getenv("CLASSPATH")) == 0) {
	    cps = ".:classes";
	}
	if ((cps = strdup(cps)) == 0) {
	    return 0;
	}
	for (s = cps; *s != '\0'; s++) {
	    if (*s == ':') {
		ncpe++;
	    }
	}
	cpp = classpath = malloc((ncpe + 1) * sizeof(cpe_t *));
	if (cpp == 0) {
	    return 0;
	}
	while (cps && *cps) {
	    struct stat sbuf;
	    char *path = cps;
	    if ((cps = strchr(cps, ':')) != 0) {
		*cps++ = '\0';
	    }
	    if (*path == '\0') {
		path = ".";
	    }
	    if (stat(path, &sbuf) == 0 && S_ISREG(sbuf.st_mode)) {
		zip_t *zip = zip_open(path);
		if (zip != 0) {
		    cpe_t *cpe = malloc(sizeof(cpe_t));
		    if (cpe == 0) {
			return 0;
		    }
		    cpe->type = CPE_ZIP;
		    cpe->u.zip = zip;
		    *cpp++ = cpe;
		}
	    } else {
		cpe_t *cpe = malloc(sizeof(cpe_t));
		if (cpe == 0) {
		    return 0;
		}
		cpe->type = CPE_DIR;
		cpe->u.dir = path;
		*cpp++ = cpe;
	    }
	}
	*cpp = 0;
    }
    return classpath;
}
