
#include <stdio.h>
#include <stdlib.h>
#include <net/netdb.h>
#include <sys/types.h>

#include "java_net_InetAddress.h"
#include "sun_net_MulticastSocket.h"
#include "java_io_FileDescriptor.h"

#define JAVANETPKG 	"java/net/"

#define IN_CLASSD(i)	(((long)(i) & 0xf0000000) == 0xe0000000)
#define IN_MULTICAST(i)	IN_CLASSD(i)

/* Multicast Socket classes */
/* These classes should be part of java.net not sun.net - and when 
this happens, move the code below to socket.c */

/* Right now, the BeOS sockets provide no support for multicasting
   we could add it but right now there are more important parts of
   the code to worry about. Paul.
*/

#define NOT_IMPLEMENTED

void sun_net_MulticastSocket_multicastJoin(struct Hsun_net_MulticastSocket *this, struct Hjava_net_InetAddress *mcast_address)
{
#ifdef NOT_IMPLEMENTED
	fprintf(stderr, "multicast.c: sun_net_MulticastSocket_multicastJoin not implemented\n");
#else	
  struct sockaddr_in name;
  struct ip_mreq mname;
  Classjava_net_InetAddress *addrptr;
  Classsun_net_MulticastSocket *thisptr = unhand(this);
  Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);

  if (fdptr == 0) {
    SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
    return;
  }
  if (mcast_address == 0) {
      SignalError(0, JAVAPKG "NullPointerException", 0);
      return;
  }

  addrptr = unhand(mcast_address);  

  /* Set the multicast group address in the ip_mreq field */
  /* eventually this check should be done by the security manager */
  mname.imr_multiaddr.s_addr = htonl(addrptr->address);
  if (!IN_MULTICAST(mname.imr_multiaddr.s_addr)) {
        struct execenv *ee = EE();
        if (!(ee && exceptionOccurred(ee))) {
            SignalError(0, JAVANETPKG "SocketException", "IN_MULTICAST");
        }
  }
  /* Set the interface to be default */
  mname.imr_interface.s_addr = INADDR_ANY;
  
  /* Join the multicast group */
  if (setsockopt(fdptr->fd- 1, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *) &mname,
	   sizeof (mname)) < 0) {
        struct execenv *ee = EE();
        if (!(ee && exceptionOccurred(ee))) {
            SignalError(0, JAVANETPKG "SocketException", "setsockopt");
        }
  }
  return;
#endif
}

void sun_net_MulticastSocket_multicastLeave(struct Hsun_net_MulticastSocket *this, struct Hjava_net_InetAddress *mcast_address)
{
#ifdef NOT_IMPLEMENTED
	fprintf(stderr, "multicast.c: sun_net_MulticastSocket_multicastLeave not implemented\n");
#else	
  struct sockaddr_in name;
  struct ip_mreq mname;
  Classjava_net_InetAddress *addrptr;
  Classsun_net_MulticastSocket *thisptr = unhand(this);
  Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);

  if (fdptr == 0) {
    SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
    return;
  }

  if (mcast_address == 0) {
      SignalError(0, JAVAPKG "NullPointerException", 0);
      return;
  }

  addrptr = unhand(mcast_address);  

  /* Set the multicast group address in the ip_mreq field */
  /* eventually this check should be done by the security manager */
  mname.imr_multiaddr.s_addr = htonl(addrptr->address);
  if (!IN_MULTICAST(mname.imr_multiaddr.s_addr)) {
        struct execenv *ee = EE();
        if (!(ee && exceptionOccurred(ee))) {
            SignalError(0, JAVANETPKG "SocketException", "IN_MULTICAST");
        }
  }
  /* Set the interface to be default */
  mname.imr_interface.s_addr = INADDR_ANY;
  
  /* Join the multicast group */
  if (setsockopt(fdptr->fd- 1, IPPROTO_IP, IP_DROP_MEMBERSHIP,(char *) &mname,
	   sizeof (mname)) < 0) {
        struct execenv *ee = EE();
        if (!(ee && exceptionOccurred(ee))) {
            SignalError(0, JAVANETPKG "SocketException", "setsockopt");
        }
  }
  return;
#endif
}

void sun_net_MulticastSocket_setTTL(struct Hsun_net_MulticastSocket *this, 
char ttl)
{
#ifdef NOT_IMPLEMENTED
	fprintf(stderr, "multicast.c: sun_net_MulticastSocket_setTTL not implemented\n");
#else	
Classsun_net_MulticastSocket *thisptr = unhand(this);
Classjava_io_FileDescriptor *fdptr = unhand(thisptr->fd);

    if (fdptr == 0) {
      SignalError(0, JAVAPKG "NullPointerException", "null FileDescriptor");
      return;
    }

    /* setsockopt to be correct ttl */
    if (setsockopt(fdptr->fd -1, IPPROTO_IP, IP_MULTICAST_TTL, (char*)&ttl,
	    sizeof (ttl)) < 0) {
	struct execenv *ee = EE();
	if (!(ee && exceptionOccurred(ee))) 
	    SignalError(0, JAVANETPKG "SocketException", "setsockopt");
    }
#endif
}
