/*
 * @(#)linker_md.c	1.14 95/12/03  
 *
 */

/*
 * Machine Dependent implementation of the dynamic linking support
 * for java.  This routine is Be specific.
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>

#include <KernelKit.h>
#include <StorageKit.h>

extern "C" {

#include "sys_api.h"
#include "path_md.h"

static int linkerinitialized = 0;

void out_of_memory(void);
int jio_snprintf(char *str, size_t count, const char *fmt, ...);

/* Bit of a hack. Assume you won't be loading more than 100 libraries. Paul. */

#define MAX_IMAGES	100

static image_id JVMimages[MAX_IMAGES];
static int image_index = 0;

static sem_id DynamicLinkMutex;


/*
 * create a string for the dynamic lib open call by adding the
 * appropriate pre and extensions to a filename and the path
 */
void
sysBuildLibName(char *holder, int holderlen, char *pname, char *fname)
{
    /* Quietly truncate on buffer overflow.  Should be an error. */
    (void) jio_snprintf(holder, holderlen, "%s/lib%s.so", pname, fname);
    return;
}

/*
 * Initialize the linker
 */
char *
sysInitializeLinker()
{
    static char *ldpath=0;
	const char *nopath = "";
	thread_id tid = find_thread(NULL);
	team_id teem;
	team_info teamInfo;
	thread_info tinfo;
	long n = 0;
	image_info JVM_image;

	/* find out where our B_APP_IMAGE is */
	
	get_thread_info(tid, &tinfo);
	teem = tinfo.team;
	get_team_info(teem, &teamInfo);
	
	while (get_nth_image_info(teem, n++, &JVM_image) == B_NO_ERROR) {
		if (JVM_image.type == B_APP_IMAGE) break;
	}	
	
	JVMimages[image_index++] = JVM_image.id;
	
	if ((DynamicLinkMutex = create_sem(1, "DynamicLinkMutex")) < B_NO_ERROR) {
		fprintf(stderr, "sysInitializeLinker: create_sem/DynamicLinkMutex failed, serious error\n");
    }
    /*
     * setup linker search paths
     */
	if (!linkerinitialized) {
	    if ((ldpath = getenv("LD_LIBRARY_PATH")) != 0) {
			if ((ldpath = strdup(ldpath)) == 0) {
			    out_of_memory();
			}
	    }
		linkerinitialized = 1;
	}
	if (ldpath) return ldpath;
	else return (char *) nopath;
}

/* 
 * Add a shared library to the list
 */
int
sysAddDLSegment(char *fn)
{

	BFile addon_file;
	record_ref addon_ref;
	image_id addon_image;
	
	if (image_index == MAX_IMAGES) return 0;
	
	if (get_ref_for_path(fn, &addon_ref) != B_NO_ERROR) return 0;
	addon_file.SetRef(addon_ref);
	
	addon_image = load_add_on(&addon_file);
	if (addon_image < B_NO_ERROR) return 0;
	JVMimages[image_index++] = addon_image;
    return 1;
}


long sysDynamicLink(char *sym_p) {

#define MAX_NAME_LENGTH		255

	static char name[MAX_NAME_LENGTH];
	long l=MAX_NAME_LENGTH, st, n = 0, i;
	void *loc;
	long error;

/* Not sure all the calls we use are re-entrant */

    if (!linkerinitialized) {
		(void)sysInitializeLinker();
    }

retry1:
    if ((error = acquire_sem(DynamicLinkMutex)) < B_NO_ERROR) {
		if (error == B_INTERRUPTED) goto retry1;
		else fprintf(stderr, "sysDynamicLink: acquire_sem failed\n");
		fflush(stderr);
    }

    
    for (i = 0; i < image_index; i++) {
	n = 0;
	while (get_nth_image_symbol(JVMimages[i], n++, name, &l, &st, &loc) == B_NO_ERROR) {
 		if (st == B_SYMBOL_TYPE_TEXT) {
			if (strcmp(name, sym_p) == 0) {
			    if (release_sem(DynamicLinkMutex) < B_NO_ERROR) {
					fprintf(stderr, "sysDynamicLink: release_sem failed\n");
			    }
				return (long) loc;
			}
			l=MAX_NAME_LENGTH;
		}
	}
    }
	printf ("sysDynamicLink(): %s not found :-(\n", sym_p);

    if (release_sem(DynamicLinkMutex) < B_NO_ERROR) {
		fprintf(stderr, "sysDynamicLink: release_sem failed\n");
    }

	return 0;	

}


}