#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#include "path_md.h"
#include "io_md.h"
#include "sys_api.h"
#include "dirent.h"

int
sysAvailable(int fd, long *pbytes)
{
    long cur, end;
    struct stat stbuf;

    if (fstat(fd, &stbuf) >= 0) {
        int mode = stbuf.st_mode;
        if (S_ISCHR(mode) || S_ISFIFO(mode)) {
	    return FALSE; /* Currently unsupported */
        }
    }
    if ((cur = lseek(fd, 0L, SEEK_CUR)) == -1) {
	return FALSE;
    } else if ((end = lseek(fd, 0L, SEEK_END)) == -1) {
	return FALSE;
    } else if (lseek(fd, cur, SEEK_SET) == -1) {
	return FALSE;
    }
    *pbytes = end - cur;
    return TRUE;
}
