
#include "io_md.h"
#include "sysmacros_md.h"
#include "fd_md.h"

/* IO routines that take in a FD object */

void sysInitFD(Classjava_io_FileDescriptor *fdptr, int desc) {
  fdptr->fd = desc+1;
}

int sysOpenFD(Classjava_io_FileDescriptor *fdobj, const char *path, int oflag,
int mode) {
  int fd = sysOpen(path, oflag, mode);
    if (fd == -1) return fd;
    
    fdobj->fd = fd+1;
    return fdobj->fd;
}

void sysCloseFD(Classjava_io_FileDescriptor *fdobj) {
    if (fdobj->fd-1 >= 0) {
      close(fdobj->fd-1);
      fdobj->fd = -1;
    }
}

int sysReadFD(Classjava_io_FileDescriptor *fdobj, char *buf, int flags) {
  return read(fdobj->fd-1, buf, flags);
}

int sysWriteFD(Classjava_io_FileDescriptor *fdobj, char *buf, int flags) {
    return write(fdobj->fd-1, buf, flags);
}

int sysAvailableFD(Classjava_io_FileDescriptor *fdobj, long *pbytes) {
  int fd = fdobj->fd-1;
  return sysAvailable(fd, pbytes);
}

long sysLseekFD(Classjava_io_FileDescriptor *fdobj, long offset, long whence) {
  return lseek(fdobj->fd-1, offset, whence);
}

