
/*-
 *      interpret an java object file
 */

#define NATIVE

#include <stdio.h>
#include <threads.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <tree.h>
#include <oobj.h>
#include <interpreter.h>
#include <javaString.h>
#include <log.h>
#include <bool.h>
#ifndef NATIVE
#include <iomgr.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <unistd.h>
#include <signal.h>
#include <sys/signal.h>
#include <exceptions.h>
#else NATIVE
#include <monitor.h>
#endif /* NATIVE */

#ifdef MONITOR
#include <mon.h>
#endif

#ifndef NATIVE
#include <java_lang_Thread.h>
#endif /* NATIVE */

extern Hjava_lang_Thread *InitializeClassThread(ExecEnv *ee, char **);
extern void InitializeMainThread(void);
extern void InitializeAlloc(long max, long min);
extern void InitializeMem(void);
#ifndef NATIVE
extern void InitializeSbrk(void);
#endif /* NATIVE */

extern void WaitToDie(void);

static void usage(void);

#ifdef MONITOR
static void MonitorTeardown(void) {
    monitor( 0, 0, 0, 0, 0 );
}

static void MonitorSetup(void) {
    extern int etext(void);
    extern int _start(void);
    int (* low)() = &_start;
    int (* high)() = & etext;
    WORD * stuff;
    int textwords = ((int)high - (int)low) / 4;
    int nbytes = sizeof(struct hdr) + 10*sizeof( struct cnt )
				    + textwords*sizeof(WORD);
    stuff = (WORD*)malloc( nbytes );
    monitor( low, high, stuff, nbytes/sizeof(WORD), 10 );
    sysAtexit( MonitorTeardown );
}
#endif

extern char **user_props;
static int nprops = 0;
static int max_props = 0;

/* add a user property */
static void add_user_prop(char *def) 
{
    char *p, *str;

    /* scan to the '=' */
    for (p = def ; *p && *p != '=' ; p++);

    /* grow the array (if needed) */
    if (nprops + 2 > max_props) {
	if (user_props == 0) {
	    user_props = (char **)calloc(16, sizeof(char *));
	    max_props = 16;
	} else {
	    char **new_props = (char **)calloc(2 * max_props, sizeof(char *));
	    memcpy(new_props, user_props, nprops * sizeof(char *));
	    free(user_props);
	    user_props = new_props;
	    max_props *= 2;
	}
    }

    /* malloc the key */
    str = (char *)malloc((p - def) + 1);
    strncpy(str, def, p - def);
    str[p - def] = '\0';
    user_props[nprops++] = str;

    /* malloc the value */
    if (*p == '=') {
	p++;
    }
    str = (char *)malloc(strlen(p) + 1);
    strcpy(str, p);
    user_props[nprops++] = str;
}

/*
 * have to put the hidden copy of the command line argument list where GC
 * will find it
 */

HArrayOfString *
commandLineArguments(int argc, char **argv, struct execenv *ee)
{
    HArrayOfString *ret = (HArrayOfString *) ArrayAlloc(T_CLASS, argc);
    if (ret == 0) {
OutOfMemory:
	SignalError(ee, JAVAPKG "OutOfMemoryError", 0);
	return 0;
    }
    /* Give the array a "type" */
    unhand((HArrayOfObject *)ret)->body[argc] = (JHandle *)classJavaLangString;
    while (--argc >= 0) {
	char *s = argv[argc];
	if ((unhand(ret)->body[argc] = makeJavaString(s, strlen(s))) == 0)
	    goto OutOfMemory;
    }
    return (HArrayOfString *) ret;
}

long
atomi(register char *p)
{
    long v = 0;
    long mult = 1;
    long c;
    while (c = *p++)
	switch (c) {
	case 'M':
	case 'm':
	    mult = 1024 * 1024;
	    break;
	case 'K':
	case 'k':
	    mult = 1024;
	    break;
	default:
	    if (c < '0' || c > '9')
		return -1;
	    v = v * 10 + c - '0';
	    break;
	}
    return v * mult;
}

/*
 * The reason we do not use this routine anymore is that we explicitly
 * leave stdin, stdout, and stderr, unblocked i.e we do not mark this 
 * file descriptors nonblocking and hence we do not have to undo i.e
 * mark them blocking before we exit anymore.  Look at iomgr.c for how
 * these fds are left unmarked and more details
 */
#ifndef NATIVE
void
makeTTYsane()
{
    nonblock_io(0, IO_BLOCK);
    nonblock_io(1, IO_BLOCK);
    nonblock_io(2, IO_BLOCK);
}
#endif NATIVE

extern void InitializeAsyncMonitors(void);

#include <path_md.h>

/*
 * Default values for minimum and maximum amounts of memory to devote
 * to the Java heap.  The current abstraction, which may not hold up
 * forever, is that the initial size of the heap is the minimum heap.
 *
 * The maximum memory to map: As we're mmapping the memory, it looks
 * like we should ask swapctl(2) how much swap we have, and thus what
 * the maximum we've got is.
 *
 * These values can be overridden on the java command line.
 */
#ifdef USE_MALLOC
#define MINHEAPSIZE ((int) ( 3 * (1024*1024)))
#define MAXHEAPSIZE MINHEAPSIZE
#else
#define MINHEAPSIZE ((int) ( 1 * (1024*1024)))
#define MAXHEAPSIZE ((int) (16 * (1024*1024)))
#endif /* USE_MALLOC */

/*
 * The default thread stack size.  This is machine-dependent, because it
 * is based on a platform's C stack usage.
 */
#define PROCSTACKSIZE (128 * 1024)     /* Default size of a thread C stack */
long ProcStackSize = PROCSTACKSIZE;

extern void intrInit(void);
extern void InitializeAsyncIO(void);


//#define FILE_DEBUG

int
start_java(argc, argv)
    register char **argv;
{
    char *sourcefile = 0;
    char **args = argv;
    char **dargv = argv;
    int MinHeapSize = MINHEAPSIZE;
    int MaxHeapSize = MAXHEAPSIZE;
    long T;
    Hjava_lang_Thread *self;
    int on_exit(void (*)(), void *);
    struct methodblock  *mb = 0;
    extern int noasyncgc;
    extern int tracegc;
    ExecEnv ee;
    char *errmsg;
    long debugport = 0L;


    /* Initialize the monitor registry */
	
// Initialize the lock semaphores we use in monitor_md.c
	sysInitializeMonitors();
	
    monitorRegistryInit();

    /* Create the monitor cache */
    monitorCacheInit();

#ifndef NATIVE
    /* Initialize the special case for sbrk on Solaris (see synch.c) */
    InitializeSbrk();
    /* Initialize the async io */
    InitializeAsyncIO();
#endif NATIVE

    {   /* assume -cs if executed as "java"
	   rather than "java" [DOES THIS MAKE SENSE ANY MORE??? */
	char *p = &argv[0][strlen(argv[0]) - 1];
	if (p[0] == 'g' && p[-1] == '_')
	    p -= 2;
	if (p[0] != 'k')
	    SkipSourceChecks = 1;
    }

    /* Store the base of the primordial thread's stack */
    mainstktop = (stackp_t) &argc;

    if ((progname = strrchr(argv[0], LOCAL_DIR_SEPARATOR)) != 0) {
	progname++;
    } else {
	progname = argv[0];
    }

    verifyclasses = VERIFY_REMOTE; /* we've decided this is the default */
    while (--argc > 0)
	if ((++argv)[0][0] == '-' && sourcefile == 0)
#ifndef trace
	    if (strcmp(*argv, "-t") == 0)
		trace++;
	    else if (strcmp(*argv, "-tm") == 0)
		tracem++;
	    else
#endif
#ifdef MONITOR
	    if (strcmp(*argv, "-m") == 0) {
    		MonitorSetup();
	    }
	    else
#endif	    
            if (strcmp(*argv, "-v") == 0 || strcmp(*argv, "-verbose") == 0)
		verbose++;
	    else if (strcmp(*argv, "-debug") == 0)
		debugagent = 1;
	    else if (strcmp(*argv, "-debuggable") == 0)
#if 0 /* Disable for 1.0.2 */
		debugagent = 2;
#else
               /*ignore*/;
#endif
	    else if (strncmp(*argv, "-debugport", 10) == 0 &&
		     (T = atomi(&argv[0][10])) >= 0)
		debugport = T;
	    else if (strcmp(*argv, "-noasyncgc") == 0)
		noasyncgc++;
	    else if (strcmp(*argv, "-verbosegc") == 0)
		verbosegc++;
	    else if (strcmp(*argv, "-verify") == 0)
		verifyclasses = VERIFY_ALL;
            else if (strcmp(*argv, "-verifyremote") == 0)
		verifyclasses = VERIFY_REMOTE;
            else if (strcmp(*argv, "-noverify") == 0)
		verifyclasses = VERIFY_NONE;
	    else if (strcmp(*argv, "-tracegc") == 0)
		tracegc++;
	    else if (strcmp(*argv, "-prof") == 0) {
		extern void javamon(int i);
		sysAtexit(java_mon_dump);
		javamon(1);
	    } else if (strcmp(*argv, "-cs") == 0 || 
		     strcmp(*argv, "-checksource") == 0)
		SkipSourceChecks = 0;
	    else if (strncmp(*argv, "-ss", 3) == 0 &&
		     (T = atomi(&argv[0][3])) > 1000)
		ProcStackSize = T;
	    else if (strncmp(*argv, "-oss", 3) == 0 &&
		     (T = atomi(&argv[0][3])) > 1000)
		JavaStackSize = T;
	    else if (strncmp(*argv, "-ms", 3) == 0 &&
		     (T = atomi(&argv[0][3])) > 1000)
		MinHeapSize = T;
	    else if (strncmp(*argv, "-mx", 3) == 0 &&
		     (T = atomi(&argv[0][3])) > 1000)
		MaxHeapSize = T;
            else if (strncmp(*argv, "-D", 2) == 0)
		add_user_prop(*argv + 2);
#ifdef LOGGING
	    else if (strncmp(*argv, "-l", 2) == 0 &&
		     (T = atomi(&argv[0][2])) >= 0)
		logging_level = T;
#endif
	    else if (strncmp(*argv, "-classpath", 10) == 0) {
		if (argc > 1) {
		    char *buf = (char *)malloc(strlen(argv[1]) + 32);
		    sprintf(buf, "CLASSPATH=%s", argv[1]);
		    putenv(buf);
		    argc--; argv++;
		} else {
		    fprintf(stderr,
			    "-classpath requires class path specification\n");
		    usage();
		    return 1;
		}
	    } else if (strcmp(*argv, "-h") == 0 || 
                       strcmp(*argv, "-help") == 0 ||
		       strncmp(*argv, "?", 1) == 0 || 
                       strncmp(*argv, "-?", 2) == 0) {
		usage();
		return 0;
            } else if (strcmp(*argv, "-version") == 0) {
                fprintf(stderr, "%s version \"%s\"\n", progname, RELEASE);
                return 0;
	    } else {
		fprintf(stderr, "%s: illegal argument\n", *argv);
		usage();
		return 1;
	    }
	else if (sourcefile)
	    *dargv++ = *argv;
	else {
	    sourcefile = *argv;
	}
    *dargv = 0;
    InitializeExecEnv(&ee, 0);  /* Call before InitializeMem() */

    if (ee.initial_stack == 0) {
	out_of_memory();
    }
    InitializeMem();		/* Could throw exception on open() */


#ifdef USE_MALLOC
    MinHeapSize = MaxHeapSize;
#endif /* USE_MALLOC */
    InitializeAlloc(MaxHeapSize, MinHeapSize);
    UseLosslessQuickOpcodes = TRUE; 
    InitializeInterpreter();	/* Call before InitializeClassThread() */


    self = InitializeClassThread(&ee, &errmsg);


    if (self == 0) {
	fprintf(stderr, "Unable to initialize threads: %s\n", errmsg);
	sysExit(1);
    }
    setThreadName(self,MakeString("main",4));


    if (!FindClass(&ee, JAVAPKG "Compiler", TRUE))
	UseLosslessQuickOpcodes = FALSE;
    
    if (sourcefile == 0) {
	usage();
	return 1;
    } if (strchr(sourcefile, '/')) {
	fprintf(stderr, "Invalid class name: %s\n", sourcefile);
	usage();
	return 1;
    } else {
	ClassClass *cb;
	int i, c;
	char classname[200];

	/* Allow the use of '.' in class names (convert to /) */
	for (i = 0; i < sizeof classname - 1 && (c = sourcefile[i]) != 0; i++) {
	    classname[i] = c;
	    if (c == '.') sourcefile[i] = '/';
	    if (c == '/') classname[i] = '.';
	}
	classname[i] = 0;

	cb = FindClass(&ee, sourcefile, TRUE);
	if (cb == 0) {
	    fprintf(stderr, "Can't find class %s\n", classname);
	    return 1;
	}

	if (debugagent) {
	    ClassClass *agentcb = FindClass(&ee, "sun/tools/debug/Agent", 
					    TRUE);
	    if (agentcb == 0) {
		fprintf(stderr, "Can't find class sun.tools.debug.Agent\n");
		return 1;
	    }
            if (debugagent == 2) {
                execute_java_static_method(0, agentcb, 
                                           "debuggable_boot", "()V");
                /* Wait for Agent to initialize. */
                monitorEnter(obj_monitor(cb->HandleToSelf));
                monitorWait(obj_monitor(cb->HandleToSelf), 1000);
                monitorExit(obj_monitor(cb->HandleToSelf));
            } else {
                execute_java_static_method(0, agentcb, 
                                           "boot", "(I)V", debugport);
            }
	}

	/* Finish initialization of the main thread */
	InitializeMainThread();


	mb = cbMethods(cb);
	for (i = cb->methods_count; --i >= 0; mb++) {
	    if ((strcmp(fieldname(&mb->fb), "main") == 0) &&
		(strncmp(fieldsig(&mb->fb), "([Ljava/lang/String;)", 20) == 0)){
		
		if (fieldsig(&mb->fb)[21] == SIGNATURE_VOID)
		    break;
		/* If we matched all the way to the return type, and its 
		 * return type is not SIGNATURE_VOID, then we know there is
		 * no method match because the compiler would complain about
		 * duplicate method declaration. */
		fprintf(stderr, "In class %s: main must return void\n",
			classname);
		return 1;
	    }
	}
	if (i < 0) {
	    fprintf(stderr, "In class %s: void main(String argv[]) is not defined\n",
		    classname);
	    return 1;
	}
	
	if ((mb->fb.access & (ACC_STATIC|ACC_PUBLIC))
	    != (ACC_STATIC|ACC_PUBLIC)) {
	    fprintf(stderr, "In class %s: main must be public and static\n", classname);
	    return 1;
	}

	do_execute_java_method(&ee, cb, 0, 0, mb, TRUE,
		       (JHandle *)commandLineArguments(dargv - args, args, &ee));
	if (exceptionOccurred(&ee)) {
	    if (ee.thread && THREAD(ee.thread)->group) {
		void *t = (void *)ee.exception.exc;
		exceptionClear(&ee);
		execute_java_dynamic_method(&ee, (void *)THREAD(ee.thread)->group, 
		    "uncaughtException", "(Ljava/lang/Thread;Ljava/lang/Throwable;)V", ee.thread, t);
	    }
	}
    }

    /*
     * The primordial thread is not allowed to exit until all user
     * threads have exited.  Note that the primordial thread's
     * resources (e.g. its Java stack) have not been reclaimed at this
     * point, even though it's got no chance of running again.  The
     * thread is still on the active thread queue and will be scanned
     * on GC, so has to be left intact.  This should be revisited.
     */

    QUEUE_LOCK();
	while (UserThreadCount > 1) {

		sysMonitorWait(_queue_lock, -1);

	}

// Release the lock semaphores we use in monitor_md.c
	sysReleaseMonitors();

    sysExit(0);
}


int
main(int argc, char **argv)
{
    return start_java(argc, argv);
}


static void
Execute(char **command, char *alternate)
{
    long pid, wpid;
    long lapcnt;
    int status = -1;
    if (verbose) {
	printf("[Executing");
	for (lapcnt = 0; command[lapcnt]; lapcnt++)
	    printf(" %s", command[lapcnt]);
	printf("]\n");
    }
    lapcnt = 0;
    while ((pid = fork()) < 0) {
	if (lapcnt == 0)
	    write(2, "[ Running out of system memory, waiting...", 42);
	lapcnt++;
	sleep(5);
    }
    if (pid) {
	if (lapcnt)
	    write(2, " got it ]\n", 10);
	while ((wpid = wait(&status)) == -1 || wpid != pid);
	if (status != 0) {
	    fprintf(stderr, "%s: failed (%X)\n", command[0], status);
	    sysExit(1);
	}
    } else {
	lapcnt = 0;
	while (1) {
	    execvp(command[0], command);
	    if (alternate)
		execvp(alternate, command);
	    if (errno != ENOMEM) {
		perror(command[0]);
		sysExit(1);
	    }
	    if (lapcnt == 0)
		write(2, "Waiting for system memory...\n", 29);
	    sleep(20);
	}
    }
    if (verbose)
	printf("[Finished %s]\n", command[0]);
}

/* OpenCode for the interpreter.

   Tries to open a code file (fn).  That is, a .class file.  This
   returns -1 if the specified file can be opened but cannot be
   stat'd.  REMIND: When can that happen?  It returns -2 if the
   file cannot be opened.  Otherwise, it returns a valid file
   descriptor. If SkipSourceChecks is true, then we return at that
   point.

   Otherwise, we try to recompile the source.  If fn == 0, then we
   use sfn as the source file name to use.  sfn is specified by
   LoadFile by using the source hint associated with the import
   statement, or by the source file name as extracted from the
   previously recompiled version of this class.  That only happens
   if LoadFile already successfully loaded the class, and then
   noticed that the source is more recent than the .class file it
   opened.

   If sfn is 0 then a source file name is constructed by stripping
   the ".class" off of fn and replacing it with .java.  This often
   doesn't work, because .class files can be put in difference
   directories from their source files, but it's a good guess
   sometimes.  Then javac is forked to recompile the class, and
   the resulting .class file is opened.

   In summary, OpenCode for the interpreter returns a file
   descriptor for a compiler .class file.  If it can't open the
   .class file, it forks the compiler to compile some source so
   that the .class file will be there.  If after all that there is
   still no .class file, it gives up and returns -2.

   If st == 0, then doesn't even bother trying to open the file.
   Instead, it just does the source file thing. */

int
OpenCode(char *fn, char *sfn, char *dir, struct stat * st)
{
    long fd = -1;
#define SRCNAMELEN 300
    char srcname[SRCNAMELEN];
    long len;
    long mtime;
    struct stat srcst;
    char *src, *dst;
    int i;

    if (st != 0 && fn != 0 && (fd = open(fn, 0, 0644)) >= 0
	    && fstat(fd, st) < 0) {
	close(fd);
	fd = -1;
    }
    if (SkipSourceChecks)
	return fd < 0 ? -2 : fd;
    dst = srcname;
    *dst++ = '-';
    *dst++ = 'G';
    if (sfn == 0) {
	sysAssert(fn);
	for (i = 2, src = fn; i < SRCNAMELEN - 1 && (*dst++ = *src++); i++);
	if (dst - srcname < 3 + JAVAOBJEXTLEN
		|| strcmp(dst - JAVAOBJEXTLEN - 2,
			  "." JAVAOBJEXT) != 0)
	    return fd < 0 ? -2 : fd;
	dst -= JAVAOBJEXTLEN + 2;
	strcpy(dst, "." JAVASRCEXT);
    } else {
	for (i = 2, src = sfn; i < SRCNAMELEN - 1 && (*dst++ = *src++); i++);
    }
    if (i == SRCNAMELEN - 1) *dst = '\0';

    while (dst > srcname + 2 && dst[-1] != '/')
	dst--;
    mtime = ((fd < 0 && fn) || st == 0) ? 0 : st->st_mtime;
    if (stat(srcname + 2, &srcst) < 0)
	srcst.st_mtime = 0;
    if (srcst.st_mtime > mtime) {
	/* Ought to be enough space... */
	char *com[30];
	char **comp = com;
	if (fd >= 0) {
	    close(fd);
	    fd = -1;
	}
#ifdef DEBUG
	*comp++ = "javac_g";
#else
	*comp++ = "javac";
#endif
	if (verbose)
	    *comp++ = "-verbose";
	if (dir) {
	    *comp++ = "-d";
	    *comp++ = dir;
	}
	*comp++ = srcname+2;
	*comp = 0;
	{
	    char    path[256];
	    char    *alt = 0;
	    char    *ep;

	    if ((ep = getenv("JAVA_HOME")) == 0)
		alt = 0;
	    else {
#ifdef DEBUG
		jio_snprintf(path, sizeof(path), "%s/bin/%s", ep, "javac_g");
#else
		jio_snprintf(path, sizeof(path), "%s/bin/%s", ep, "javac");
#endif
		alt = path;
	    }
	    Execute(com, alt);
	}
	if (fn) {
	    fd = open(fn, 0, 0644);
	    if (fd >= 0 && st)
		if (fstat(fd, st) < 0) {
		    close(fd);
		    fd = -1;
		}
	}
    }
    return fd < 0 ? -2 : fd;
}

static void usage()
{
    fprintf(stderr, "Usage: %s [-options] class\n", progname);
    fprintf(stderr, "\n");
    fprintf(stderr, "where options include:\n");
    fprintf(stderr, "    -help             print out this message\n");
    fprintf(stderr, "    -version          print out the build version\n");
#ifndef trace
    fprintf(stderr, "    -t                turn on instruction tracing\n");
    fprintf(stderr, "    -tm               turn on method tracing\n");
#endif
#ifdef MONITOR
    fprintf(stderr, "    -m                turn on monitoring\n");
#endif
    fprintf(stderr, "    -v -verbose       turn on verbose mode\n");
    fprintf(stderr, "    -debug            enable remote JAVA debugging\n");
#if 0 /* Disable for 1.0.2 */
    fprintf(stderr, "    -debuggable       enable single-process JAVA debugging\n");
#endif
    fprintf(stderr, "    -noasyncgc        don't allow asynchronous gc's\n");
    fprintf(stderr, "    -verbosegc        print a message when GCs occur\n");
    fprintf(stderr, "    -cs -checksource  check if source is newer when loading classes\n");
    fprintf(stderr, "    -ss<number>       set the C stack size of a process\n");
    fprintf(stderr, "    -oss<number>      set the JAVA stack size of a process\n");
    fprintf(stderr, "    -ms<number>       set the initial Java heap size\n");
    fprintf(stderr, "    -mx<number>       set the maximum Java heap size\n");
    fprintf(stderr, "    -D<name>=<value>  set a system property\n");
#ifdef LOGGING
    fprintf(stderr, "    -l<number>        set the logging level\n");
#endif
    fprintf(stderr, "    -classpath <directories separated by colons>\n");
    fprintf(stderr, "                      list directories in which to look for classes\n");
    fprintf(stderr, "    -prof             output profiling data to ./java.prof\n");
    fprintf(stderr, "    -verify           verify all classes when read in\n");
    fprintf(stderr, "    -verifyremote     verify classes read in over "
                                              "the network [default]\n");
    fprintf(stderr, "    -noverify         do not verify any class\n");
}
