/*
 * BeOSProcess by Paul
 */

package java.lang;

import java.io.*; 

public class BeOSProcess extends Process {
    private int pid = 0;
    private FileDescriptor stdin_fd;
    private FileDescriptor stdout_fd;
    private FileDescriptor stderr_fd;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;

    BeOSProcess(String cmd[], String env[]) throws Exception {
	
		stdin_fd = new FileDescriptor();
		stdout_fd = new FileDescriptor();
		stderr_fd = new FileDescriptor();
		
		forkexec(cmd, env);
		stdin_stream = new BufferedOutputStream(new FileOutputStream(stdin_fd));
		stdout_stream = new BufferedInputStream(new FileInputStream(stdout_fd));
		stderr_stream = new FileInputStream(stderr_fd);
    }

    public OutputStream getOutputStream() {
		return stdin_stream;
    }

    public InputStream getInputStream() {
		return stdout_stream;
    }

    public InputStream getErrorStream() {
		return stderr_stream;
    }

    public void finalize() {
		close();
    }

    public native int exitValue();
    public native int waitFor();
    public native void destroy();

    private native void forkexec(String cmdstr[], String envstr[]);
    private native void close();
}
