
/*
 * Be-dependent types
 */

#ifndef _BE_TYPES_MD_H_
#define _BE_TYPES_MD_H_

#include <sys/types.h>
#include <sys/stat.h>
#include "bool.h"

#ifndef	_UINT64_T
#define	_UINT64_T
typedef struct {
	unsigned long uh, ul;
} uint64_t;
#define _UINT32_T
typedef unsigned long uint32_t;
#endif

#ifndef	_INT64_T
#define	_INT64_T
typedef struct {
	long sh, sl;
} int64_t;
#define _INT32_T
typedef long int32_t;
#endif

typedef uint32_t uint_t;

#define INLINE_FUNC

#ifdef __cplusplus
extern "C" {
#endif

#define ll_high(a)		((a).sh)
#define ll_low(a)		((a).sl)
int64_t int2ll(int);
int 	ll2int(int64_t);
int64_t ll_add(int64_t, int64_t);
int64_t ll_and(int64_t, int64_t);
int64_t ll_div(int64_t, int64_t);
int64_t ll_mul(int64_t, int64_t);
int64_t ll_neg(int64_t);
int64_t ll_not(int64_t);
int64_t ll_or(int64_t, int64_t);
int64_t ll_shl(int64_t, int);
int64_t ll_shr(int64_t, int);
int64_t ll_sub(int64_t, int64_t);
int64_t ll_shr(int64_t, int);
int64_t ll_ushr(int64_t, int);
int64_t ll_xor(int64_t, int64_t);
int64_t uint2ll(unsigned int);
int64_t ll_rem(int64_t, int64_t);
int64_t float2ll(float);
float 	ll2float(int64_t);
int64_t double2ll(double);
float 	ll2double(int64_t);
#define ll_ltz(a)		((a).sh < 0) ? 1 : 0
#define ll_gez(a)		((a).sh >= 0) ? 1 : 0
#define ll_eqz(a)		((a).sh == 0 && (a).sl == 0) ? 1 : 0
#define ll_eq(a, b)		((a).sh == (b).sh && (a).sl == (b).sl) ? 1 : 0
#define ll_ne(a,b)		((a).sh != (b).sh || (a).sl != (b).sl) ? 1 : 0
#define ll_ge(a,b)		(((a).sh > (b).sh) || \
						((a).sh == (b).sh &&  \
						((unsigned long)(a).sl) >= ((unsigned long)(b).sl))) ? 1 : 0
#define ll_le(a,b)		(((a).sh < (b).sh) || \
						((a).sh == (b).sh &&  \
						((unsigned long)(a).sl) <= ((unsigned long)(b).sl))) ? 1 : 0
#define ll_gt(a,b)		(((a).sh > (b).sh) || \
						((a).sh == (b).sh &&  \
						((unsigned long)(a).sl) > ((unsigned long)(b).sl))) ? 1 : 0
#define ll_lt(a,b)		(((a).sh < (b).sh) || \
						((a).sh == (b).sh &&  \
						((unsigned long)(a).sl) < ((unsigned long)(b).sl))) ? 1 : 0

extern int64_t ll_zero_const, ll_one_const;

char * myll2str (int64_t);
void ll2str(int64_t, char *, char *);
char * hex_ll2str(int64_t);

#undef INLINE_FUNC

#ifdef __cplusplus
}
#endif


/* use these macros when the compiler supports the long long type */

/*
#define ll_high(a)	((long)((a)>>32))
#define ll_low(a)	((long)(a))
#define int2ll(a)	((int64_t)(a))
#define ll2int(a)	((int)(a))
#define ll_add(a, b)	((a) + (b))
#define ll_and(a, b)	((a) & (b))
#define ll_div(a, b)	((a) / (b))
#define ll_mul(a, b)	((a) * (b))
#define ll_neg(a)	(-(a))
#define ll_not(a)	(~(a))
#define ll_or(a, b)	((a) | (b))
#define ll_shl(a, n)	((a) << (n))
#define ll_shr(a, n)	((a) >> (n))
#define ll_sub(a, b)	((a) - (b))
#define ll_ushr(a, n)	((unsigned long long)(a) >> (n))
#define ll_xor(a, b)	((a) ^ (b))
#define uint2ll(a)	((uint64_t)(unsigned long)(a))
#define ll_rem(a,b)	((a) % (b))

#define float2ll(f)	((int64_t) (f))
#define ll2float(a)	((float) (a))
#define ll2double(a)	((double) (a))
#define double2ll(f)	((int64_t) (f))

#define ll_ltz(ll)	((ll)<0)
#define ll_gez(ll)	((ll)>=0)
#define ll_eqz(a)	((a) == 0)
#define ll_eq(a, b)	((a) == (b))
#define ll_ne(a,b)	((a) != (b))
#define ll_ge(a,b)	((a) >= (b))
#define ll_le(a,b)	((a) <= (b))
#define ll_lt(a,b)	((a) < (b))
#define ll_gt(a,b)	((a) > (b))

#define ll_zero_const	((int64_t) 0)
#define ll_one_const	((int64_t) 1)
*/

#endif /* !_BE_TYPES_MD_H_ */
