
#ifndef _BE_SYSMACROS_MD_H_
#define _BE_SYSMACROS_MD_H_

#define sysMalloc	malloc
#define sysFree		free
#define sysCalloc	calloc
#define sysRealloc	realloc

/* filesystem macros */

#define sysRename(s, d)	(rename(s, d))

#ifdef DEBUG
extern void DumpThreads(void);
void panic (const char *, ...);
#define sysAssert(expression) {		\
    if (!(expression)) {		\
	DumpThreads();			\
	panic("\"%s\", line %d: assertion failure\n", __FILE__, __LINE__); \
    }					\
}
#else
#define sysAssert(expression) 0
#endif

/*
 * Check whether an exception occurred.  This also gives us the oppor-
 * tunity to use the already-required exception check as a trap for other
 * system-specific conditions.
 */
#define sysCheckException(ee) \
	if (!exceptionOccurred(ee)) { \
	   continue; \
	}

/* declare sysMonitor... calls that we have created. Paul. */

int sysMonitorNoLookup();
void sysInitializeMonitors();
void sysReleaseMonitors();


/*
 * file system macros moved here from io_md.h
 */


/* we don't have tempnam on the BeBox. But I think this hack will
   be sufficient to replace it. If not, it's not hard to write. Paul */
#define tempnam(dir, file)			tmpnam(NULL)


#define sysOpen(_path,_oflag,_mode)	open(_path,_oflag,_mode)
#define sysSeek(fd, offset, whence)	lseek(fd, offset, whence)
#define sysRead(_fd,_buf,_n)		read(_fd,_buf,_n)
#define sysWrite(_fd,_buf,_n)		write(_fd,_buf,_n)
#define sysClose(_fd)				close(_fd)
#define sysUnlink(_path)			unlink(_path)
#define sysStat(_path,_buf)			stat(_path,_buf)
#define sysMkdir(_path,_mode)		mkdir(_path,_mode)
#define sysIsAbsolute(_path)		(*(_path) == '/')
#define sysCloseDir(_dir)			closedir(_dir)
#define sysOpenDir(_path)			opendir(_path)
#define sysReadDir(_dir)			readdir(_dir)

#endif /*_BE_SYSMACROS_MD_H_*/
