#!/bin/sh
#
# Determine JAVA_HOME
#

CLASSPATH="$CLASSPATH"
export CLASSPATH

if [ -z "$JAVA_HOME" ] ; then
    JAVA_HOME=`dirname $0`
    JAVA_HOME=`cd $JAVA_HOME/.. ; /bin/pwd`
fi

if [ ! -d "$JAVA_HOME" ] ; then
    echo "Invalid JAVA_HOME: $JAVA_HOME" 1>&2 
    exit 1
fi

if [ ! -r "$JAVA_HOME/lib/classes.zip" ] ; then
    if [ ! -d "$JAVA_HOME/classes" ] ; then
       echo "Invalid JAVA_HOME: $JAVA_HOME" 1>&2 
       exit 1
    fi
fi

#
# Parse arguments
#
namearg=0
for a in $* ; do
  if [ $namearg -eq 0 ]
    then
      case "$a" in 
	-classpath) opts="$opts $a"
		    namearg=1 ;;
	*)      args="$args $a" ;;
      esac
  else
    opts="$opts $a"
    namearg=0
  fi
done

#
# Run javadoc
#

eval exec $JAVA_HOME/bin/java $opts -ms8m -verbosegc sun.tools.javadoc.Main $args
