//------------------------------------------------------------
// StormSaver.cpp by Simon Clarke (S.J.Clarke@herts.ac.uk)
//------------------------------------------------------------

#include "StormSaver.h"
#include "DrawStorm.h"

const rgb_color	kBlack		= {0, 0, 0, 0};
const rgb_color	kWhite		= {255, 255, 255, 0};

DrawStorm *module = NULL;

//char inhibit_random = 1;

void
module_initialize(
	void	*inSettings,
	long	inSettingsSize)
{
}

void
module_cleanup(
	void	**outSettings,
	long	*outSettingsSize)
{
	*outSettings = NULL;
	*outSettingsSize = 0;
}

void
module_start_saving(
	BView	*inView)
{
	srand((long)system_time());
	
	inView->Window()->Show();
	
	module = new DrawStorm(inView);
	module->Save();
}

void
module_stop_saving()
{
	module->Stop();
	delete module;
	module=NULL;
}

void
module_start_config(
	BView *inView)
{
	inView->Window()->Lock();
	BRect b = inView->Bounds();
	rgb_color viewc = inView->ViewColor();
	
	BStringView *str1 = new BStringView(BRect(2,6,110,18),"","Storm");
	str1->SetViewColor(viewc);
	inView->AddChild(str1);	
	str1->SetFontName("Emily");
	
	BStringView *str2 = new BStringView(BRect(3,20,210,32),"","by Simon Clarke (S.J.Clarke@herts.ac.uk)");
	str2->SetViewColor(viewc);
	inView->AddChild(str2);

	BStringView *str3 = new BStringView(BRect(3,33,210,45),"","based on a module by David Kinder");
	str3->SetViewColor(viewc);
	inView->AddChild(str3);

	inView->Window()->Unlock();
}

void
module_stop_config()
{
}

