// DrawStorm.h

#pragma once

const long RAIN_NONE = 0;
const long RAIN_LIGHT =  20;
const long RAIN_HEAVY =  40;
const long RAIN_TORRENT = 70;
const long SLOW = 2;

#define RAND(v)	((rand() % v) - (v / 2))

class DrawStorm : public BObject {
public:
	DrawStorm(BView *View);
	~DrawStorm();
	void Save();
	void Stop();
	void MakeDisplay();
	void Loop();
	void DrawRain(short x, short y, short pen);
	static void DrawThread(DrawStorm *our);
	short RangeRand(short value) { return RAND(value); };
	
	short RainPos[RAIN_TORRENT][3];
	short Width,Height,RainType, RainLen, RainSpeed, RainPref;
	short RainSpeed1, RainSpeed2, LightX1, LightX2, LightY;
protected:	
	thread_id draw_thread;
	BView *view;
	BRect b;
	unsigned long fSeed;
	bool die;
};
