//----------------------------------------------------------
// DrawStorm Thread by Simon Clarke
//----------------------------------------------------------

#include "DrawStorm.h"

DrawStorm::DrawStorm(BView *View)
{
	view = View;
	die = FALSE;
}

DrawStorm::~DrawStorm()
{
}

void DrawStorm::Save() 
{
	draw_thread = spawn_thread((thread_entry)DrawThread,"Draw Thread",B_LOW_PRIORITY,this);
	resume_thread(draw_thread);
}

void DrawStorm::Stop()
{
	long ret;
	// lame exit method, due to HUGE race problems with kill_thread()
	die = TRUE;
	wait_for_thread(draw_thread,&ret);
}

void DrawStorm::DrawThread(DrawStorm *our)
{
	our->MakeDisplay();
	our->Loop();
}

void DrawStorm::Loop()
{
	int i, slow_rain = 6;

	do {
		snooze(6500);
	
		for (i = 0, RainSpeed = RainSpeed1; i < RainType; i++) {
			
			if (i == RainType/2) RainSpeed = RainSpeed2;
			DrawRain(RainPos[i][0],RainPos[i][1],0);
			DrawRain(RainPos[i][0],RainPos[i][1]+RainLen,RainPos[i][2]);
			RainPos[i][1] += RainSpeed;
			if (RainPos[i][2] == SLOW) RainPos[i][1]-=10;
			if (RainPos[i][1] >= Height + RainSpeed) {
				RainPos[i][0] = rand() % Width;
				RainPos[i][1] = RainLen*-1;
				RainPos[i][2] = 1;
				if (slow_rain == 0) {
					slow_rain = 6;
					RainPos[i][2] = SLOW;			
				}
				slow_rain--;		
			}
		}
	} while (die==FALSE);
}

void DrawStorm::MakeDisplay()
{
	if (!view->Window()->Lock()) return;

	b = view->Bounds();
	b.InsetBy(1,1);
	Height = b.IntegerHeight();
	Width = b.IntegerWidth();
	RainLen = Height/10;
	
	RainPref=1;
	
	switch (RainPref) {
		case 0:
			RainType = RAIN_LIGHT;
			RainSpeed1 = RainLen/2;
			RainSpeed2 = RainSpeed1;
			break;
		case 1:
			RainType = RAIN_HEAVY;
			RainSpeed1 = (RainLen/3)*2;
			RainSpeed2 = RainLen/2;
			break;			
	   	case 3:
			RainType = RAIN_TORRENT;
			RainSpeed1 = (RainLen/4)*3;
			RainSpeed2 = (RainLen/3)*2;
			break;
    }

	int slow_rain=5;

	if (RainType != RAIN_NONE) {
    	for (int i = 0; i < RainType; i++) {
			short tmp =  (unsigned)rand() % Width;
			if (tmp < 0) tmp +=Width/2;
			RainPos[i][0] = tmp;
			RainPos[i][1] = RangeRand(Height + RainLen) - RainLen;
			RainPos[i][2] = 1;
		
			if (slow_rain == 0) {
				slow_rain = 5;
				RainPos[i][2] = SLOW;			
			}
			slow_rain--;
    	}
	}		 
	view->Window()->Unlock();
}

void DrawStorm::DrawRain(short x, short y, short pen)
{
	short end_y = 0;
	
	if (!view->Window()->Lock()) return;
	
	if (y <= 0) y = 0+2;
    else if (y >= Height) y = Height-1;

  	if ((end_y = y + RainSpeed) < 0) end_y = 0;
  	else if (end_y >= Height) end_y = Height-1;

	if (y != end_y) {
		if (pen == 0) view->SetHighColor(0,0,0,0);
		else if (pen == SLOW) {
			view->SetHighColor(10,78,130,0);
		}
		else if (pen == 1) view->SetHighColor(0,78,240,0);

		view->StrokeLine(BPoint(x,y),BPoint(x,end_y),B_SOLID_HIGH);
	}
	view->Window()->Unlock();
}
