
#define MAXSNOWFLAKES 1000		/* Max no. of snowflakes */
#define INITIALSNOWFLAKES 100	/* Initial no. of snowflakes */
#define MAXYSTEP 8				/* falling speed max */
#define MAXXSTEP 4				/* drift speed max */
#define WHIRLFACTOR 4
#define INITWINSNOWDEPTH 15
#define INITIALSCRPAINTSNOWDEPTH 8  /* Painted in advance */
#define INITSCRSNOWDEPTH 50		/* Will build up to INITSCRSNOWDEPTH */
#define SNOWFREE 25				/* Must stay snowfree on display :) */


typedef struct {
	int x;
	int y;
	int xStep;    /* drift */
	int yStep;    /* falling speed */
	int active;
	int visible;
	int insnow;
	int whatFlake;
} Snow;


typedef struct {
	char *bits;
	BBitmap *pixmap;
	int width;
	int height;
} PictureMap;

#define NUMSNOWFLAKETYPE 7  
#include "snow00.xbm"
#include "snow01.xbm"
#include "snow02.xbm"
#include "snow03.xbm"
#include "snow04.xbm"
#include "snow05.xbm"
#include "snow06.xbm"

PictureMap snowPix[NUMSNOWFLAKETYPE] = {
	{snow00_bits, NULL, snow00_height, snow00_width},
	{snow01_bits, NULL, snow01_height, snow01_width},
	{snow02_bits, NULL, snow02_height, snow02_width},
	{snow03_bits, NULL, snow03_height, snow03_width},
	{snow04_bits, NULL, snow04_height, snow04_width},
	{snow05_bits, NULL, snow05_height, snow05_width},
	{snow06_bits, NULL, snow06_height, snow06_width}
};


#include "tannenbaum.xbm"

PictureMap tannenbaumPix[] = {
	{tannenbaum_bits, NULL, tannenbaum_height, tannenbaum_width}
};


typedef struct {
	int x;
	int y;
	int xStep;  
	int yStep; 
	int visible;
	int whatSanta;		/* 0-2 index in pix */
} Santa;


#define NUMSANTA 3		/* 3 sizes of Santa */
#define NUMSANTAFRAMES 3 /* # animation frames per santa */

/* Speed for each Santa */
int Speed[NUMSANTA]    = {  1,   2,   4};

/* Rudolf's nose (clumsy. Oh well.) */
int NoseX[NUMSANTA]	   = { 54, 107, 214};
int NoseY[NUMSANTA]	   = {  3,   7,  15};
int NoseXSiz[NUMSANTA] = {  2,   2,   2};
int NoseYSiz[NUMSANTA] = {  1,   1,   2};


#include "sleigh1_0.xbm"
#include "sleigh1_1.xbm"
#include "sleigh1_2.xbm"
#include "sleigh2_0.xbm"
#include "sleigh2_1.xbm"
#include "sleigh2_2.xbm"
#include "sleigh3_0.xbm"
#include "sleigh3_1.xbm"
#include "sleigh3_2.xbm"

PictureMap sleighPix[][NUMSANTAFRAMES] = {
    {
	{sleigh1_0_bits, NULL, sleigh1_0_width , sleigh1_0_height},
	{sleigh1_1_bits, NULL, sleigh1_1_width , sleigh1_1_height},
	{sleigh1_2_bits, NULL, sleigh1_2_width , sleigh1_2_height},
    }, {
	{sleigh2_0_bits, NULL, sleigh2_0_width , sleigh2_0_height},
	{sleigh2_1_bits, NULL, sleigh2_1_width , sleigh2_1_height},
	{sleigh2_2_bits, NULL, sleigh2_2_width , sleigh2_2_height},
    }, {
	{sleigh3_0_bits, NULL, sleigh3_0_width , sleigh3_0_height},
	{sleigh3_1_bits, NULL, sleigh3_1_width , sleigh3_1_height},
	{sleigh3_2_bits, NULL, sleigh3_2_width , sleigh3_2_height},
    }
};


#include "santa1.xbm"
#include "santa2.xbm"
#include "santa3.xbm"

PictureMap santaPix[] = {
	{santa1_bits, NULL, santa1_width, santa1_height},
	{santa2_bits, NULL, santa2_width, santa2_height},
	{santa3_bits, NULL, santa3_width, santa3_height},
};


#include "santa1_fur.xbm"
#include "santa2_fur.xbm"
#include "santa3_fur.xbm"

PictureMap santaFurPix[] = {
	{santa1_fur_bits, NULL, santa1_fur_width, santa1_fur_height},
	{santa2_fur_bits, NULL, santa2_fur_width, santa2_fur_height},
	{santa3_fur_bits, NULL, santa3_fur_width, santa3_fur_height},
};

