#include "SnowWindow.h"
#include "besnow.h"

#define kStartTop 100
#define kStartLeft 100
#define kStartWidth 600
#define kStartHeight 600

#define InWindowMode() (modifiers() & B_COMMAND_KEY)


SnowWindow::SnowWindow()
	: BWindow(BRect(kStartLeft, kStartTop, kStartLeft+kStartWidth, kStartTop+kStartHeight), "Snow", B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE|(InWindowMode() ? 0: B_WILL_ACCEPT_FIRST_CLICK))
{
	screen_info sinfo;
	float width;
	
	get_screen_info(&sinfo);
	get_dock_width(&width);
	sinfo.frame.left += width;	/* skip over dock */

	if (InWindowMode()) {
		sinfo.frame.top += 80;	/* give room for title bar */
		sinfo.frame.left += 20;	/* move away from the dock */

		if (sinfo.frame.IntegerWidth() <= kStartWidth - 20)
			sinfo.frame.right -= 80;
		else
			sinfo.frame.right = sinfo.frame.left + kStartWidth - 1;

		if (sinfo.frame.IntegerHeight() <= kStartHeight - 20)
			sinfo.frame.bottom -= 80;
		else
			sinfo.frame.bottom = sinfo.frame.top + kStartHeight - 1;
	}
	ResizeTo(sinfo.frame.Width(), sinfo.frame.Height());
	MoveTo(sinfo.frame.LeftTop());

	Lock();
	sv = new BView(Bounds(), NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	AddChild(sv);
	Unlock();

	SnowInit(sv);
	SnowGo();
}

SnowWindow::~SnowWindow()
{
	SnowUnInit();
}

bool SnowWindow::QuitRequested()
{
	if (Snowing()) {
		SnowStop();
		/* must exit from this routine to free window's lock */
		PostMessage(B_QUIT_REQUESTED);
		return FALSE;
	}
	be_app->PostMessage(B_QUIT_REQUESTED);
	return TRUE;
}
