// ============================================================
//  SaverModule.cpp	1996 Hiroshi Lockheimer
// ============================================================

#include "SaverModule.h"
#include "besnow.h"

// Uncomment the following line to prevent 'Random' from calling
// your module

//char inhibit_random = 1;


// ------------------------------------------------------------
// 		 module_initialize  [optional]
// ------------------------------------------------------------
// This function gets called once, immediately after saver has
// loaded your module
//
// It is not known at this point whether you are being loaded
// to save the screen or to configure yourself (or both)
//
// inSettings is a pointer to data inSettingsSize long that saver 
// has stored for you, it is your responsibility to free it before 
// your module is unloaded
//
// saver may pass you NULL and 0 if it cannot find any data that
// belongs to you

void
module_initialize(
	void	*inSettings,
	long	inSettingsSize)
{
}


// ------------------------------------------------------------
// 		 module_cleanup  [optional]
// ------------------------------------------------------------
// This function gets called once, immediately before saver will
// unload your module
//
// This is the last chance to clean up after yourself
//
// Set outSettings to a pointer that is outSettingsSize long, 
// and saver will store it for you until the next time your module 
// is loaded
//
// Pass back NULL and 0 if you do not need to store anything
//
// Do not attempt to free what you pass back to saver

void
module_cleanup(
	void	**outSettings,
	long	*outSettingsSize)
{
}


// ------------------------------------------------------------
// 		 module_start_saving  [required]
// ------------------------------------------------------------
// This function gets called when it is time to "save" the screen
//
// You are given a BView in which you are to do your work
//
// The window in which the BView resides is not shown at this time,
// it is your responsibility to inView->Window()->Show() it
//
// Spawn your thread(s) here and return from this function ASAP
// Do all your drawing in inView, or in its children (if you 
// decide to add any)
//
// inView's View and Low color are set to black, High color is white
//
// saver never locks inView's window for you, so be sure to
// inView->Window()->Lock() before you try to do anything with
// inView, otherwise you win a free trip to the debugger

void
module_start_saving(
	BView	*inView)
{
	SnowInit(inView);
	inView->Window()->Show();
	SnowGo();
}


// ------------------------------------------------------------
// 		 module_stop_saving  [required]
// ------------------------------------------------------------
// This function gets called right before the BWindow that
// you have been drawing into gets closed
//
// Exit from all your thread(s), free any memory that you no 
// longer need, unlock anything that you locked, be good and 
// clean up after yourself

void
module_stop_saving()
{
	SnowStop();
	SnowUnInit();
}


// ------------------------------------------------------------
// 		 module_start_config  [required]
// ------------------------------------------------------------
// This function gets called when the user has selected your 
// module in the settings panel
//
// You are free to add any children to inView or modify it
// in any way (but don't even think about deleting it)
//
// inView is 241 units wide and 244 units high

void
module_start_config(
	BView *inView)
{
	BStringView *view = NULL;
	char buf[256];

	inView->Window()->Lock();

	sprintf(buf, "BeSnow %s", kBeSnowVersion);
	view = new BStringView(BRect(20.0, 20.0, 100.0, 32.0),
								 B_EMPTY_STRING,
								 buf);
	inView->AddChild(view);
	view->SetViewColor(inView->ViewColor());
	view->SetFontName("Emily");
	
	view = new BStringView(BRect(30.0, 35.0, 130.0, 47.0),
								 B_EMPTY_STRING,
								 "by Dean Luick.");
	inView->AddChild(view);
	view->SetViewColor(inView->ViewColor());
	view = new BStringView(BRect(20.0, 60.0, 220.0, 72.0),
								 B_EMPTY_STRING,
								 "Based on xsnow-1.40 by Rick Jansen.");
	inView->AddChild(view);
	view->SetViewColor(inView->ViewColor());
	
	inView->Window()->Unlock();
}


// ------------------------------------------------------------
// 		 module_stop_config  [required]
// ------------------------------------------------------------
// This function gets called right before the BView that was passed
// to you in module_start_config() gets deleted
//
// Free any memory that you may have allocated, you know the game...
//
// Since your view will be deleted, it is not necessary to delete 
// the children that you added to it

void
module_stop_config()
{
}

