/* vi:set ts=4 sw=4:
 *
 * VIM - Vi IMproved		by Bram Moolenaar
 *                BeBox port by Olaf 'Rhialto' Seibert
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

/*
 * bebox.c -- code that is needed beyond or instead of what's in unix.c.
 */

#include <termios.h>
#include <kernel/OS.h>
#include "vim.h"

static
int
check_for_bebox()
{
	static int checked = 0;
	static int is_bebox = 0;

	if (!checked) {
		system_info si;

		checked = 1;

		get_system_info(&si);
#if 0
		printf("\r\ncpu_count = %d\r\n", si.cpu_count);
		printf("cpu_type = %d\r\n", si.cpu_type);
		printf("cpu_clock_speed = %f\r\n", si.cpu_clock_speed);
		printf("bus_clock_speed = %f\r\n", si.bus_clock_speed);
#endif
		/*
		 * Measured values on my machine:
		 * cpu_clock_speed = 66434214
		 * bus_clock_speed = 33238632
		 */
		if (si.cpu_count == 2 &&
			((si.cpu_type == B_CPU_PPC_603  && si.cpu_clock_speed <=  66666666) ||
			 (si.cpu_type == B_CPU_PPC_603e && si.cpu_clock_speed <= 133333333)) &&
			si.bus_clock_speed <= 33333333) {
			is_bebox = 1;
		}
		//printf("io card version = %d\r\n", io_card_version());
		if (!is_bebox) {
			emsg("This program works better on a real BeBox.");
		}
	}
	return is_bebox;
}


/*
 * select() emulation. Hopefully, in DR9 there will be something
 * useful supplied by the system.
 */

int
bebox_select(int nbits,
	   struct fd_set *rbits,
	   struct fd_set *wbits,
	   struct fd_set *ebits,
	   struct timeval *timeout)
{
	check_for_bebox();
	if (nbits == 0) {
		/* select is purely being used for delay */
		/* return select(0, NULL, NULL, NULL, timeout); */
		snooze(timeout->tv_sec * 1e6 + timeout->tv_usec);
		return 0;
	}
#if 0
	/*
	 * This does not seem to work either. Reads here are not supposed to
	 * block indefinitely, yet they do. This is most annoying.
	 */
	if (FD_ISSET(0, rbits)) {
	    char cbuf[1];
	    int count;
	    struct termios told;
	    struct termios tnew;
	    tcgetattr(0, &told);
	    tnew = told;
	    tnew.c_lflag &= ~ICANON;
	    tnew.c_cc[VMIN] = 0;
	    tnew.c_cc[VTIME] = timeout->tv_sec * 10 + timeout->tv_usec / 100000;
	    tcsetattr(0, TCSANOW, &tnew);

	    count = read(0, &cbuf, sizeof(cbuf));
	    tcsetattr(0, TCSANOW, &told);
	    if (count > 0) {
		add_to_input_buf(&cbuf[0], count);
		return 1;
	    }
	    return 0;
	}
#endif
	return 0;
}

