;; -*- Emacs-Lisp -*-
;;
;; OmniMark major mode for GNU EMACS

;;{{{ Hilighting patterns

;; Set up some highlighting.
(if (featurep 'hilit19)
	(hilit-set-mode-patterns
	 'omnimark-mode
	 '((";.*$" nil comment)
	   ("\"[^%\"]*\\(%[a-z\"%]\\([^%\"]\\)*\\)*\"" nil string)
	   ("\\bdown-translate\\b" nil decl)
	   ("\\bup-translate\\b" nil decl)
	   ("\\bfind-start\\b" nil decl)
	   ("\\bfind-end\\b" nil decl)
	   ("\\bfind\\b" nil decl)
	   ("\\bdocument-start\\b" nil decl)
	   ("\\bdocument-end\\b" nil decl)
	   ("\\btranslate\\b" nil include)
	   ("\\belement\\b" nil include)
	   ("\\boutput\\b" nil keyword)
	   ("\\bsubmit\\b" nil include)
	   ("\\bmacro\\b" nil defun)
	   ("\\bmacro-end\\b" nil defun)
	   ("%[a-zA-Z0-9]+" nil defun)
	   ("%\"" nil defun)
	   ("\\bglobal\\b" nil keyword)
	   ("\\bswitch\\b" nil keyword)
	   ("\\bput\\b" nil keyword)
	   ("\\bdo\\b" nil keyword)
	   ("\\bwhen\\b" nil keyword)
	   ("\\bactive\\b" nil keyword)
	   ("\\bactivate\\b" nil keyword)
	   ("\\bdeactivate\\b" nil keyword)
	   ("\\breset\\b" nil keyword)
	   ("\\belse\\b" nil keyword)
	   ("\\bdone\\b" nil keyword))
	 nil 'case-insensitive)
  nil)

;;}}}

;; (autoload 'omnimark-mode "omnimark-mode" "OmniMark mode" t)
;; (setq auto-mode-alist (cons '("\\.xom$" . omnimark-mode) auto-mode-alist))

(defun omnimark-mode ()
  "OmniMark program editing mode."

  (interactive)

  (setq major-mode 'omnimark-mode)
  (setq mode-name "OmniMark")
  (setq comment-start ";"))

;;{{{ EMACS local variables

;; Local variables:
;; folded-file: t
;; end:

;;}}}
