/*
	
	GetIdxString
	
	Sample Code, Cyril VELTER 1996 (cyril@micronet.fr).
	
	This function extract a string from a buffer of data
	in StrL format. size is the size of the buffer and idx
	is the position of the string in the list.
	
	buf is typicaly get by file.FindResource('StrL',XX,&len)
*/


char* GetIdxString(char* Buf,long size,long idx)
{
	// current position in the buffer
	long pnt=0;
	
	// scan buffer
	while(true)
	{
		// is there at least one string (3 bytes)
		if (size-pnt>2)
		{
			// decode string length 
			short sz;
			((char*)(&sz))[0]=Buf[pnt];
			((char*)(&sz))[1]=Buf[pnt+1];
			
			// is there enought data in buffer to extract string
			if (size-pnt>=2+sz)
			{
				
				// is it our index
				if (idx==0)
				{
					// String memory allocation
					char* str=(char*)(malloc(sz+1));
					
					// String extraction
					memcpy(str,Buf+pnt+2,sz);
					
					// Fix 0 at the end of the string
					str[sz]=0;
					
					// return the string
					return str;
				}
				else
					idx--;
				pnt+=2+sz;
			}
			else
				return NULL;
		}
		else
			return NULL;
	}
	return NULL;
}


