/* ++++++++++

	/dev/zero - zero bytes, as many as you want them

	This code is placed into public domain. No warranties. Caveat Hacker.
	
	Questions? Mail me at <oa@iki.fi>

++++++ */

#include <kernel/OS.h>
#include <device/Drivers.h>
#include <device/KernelExport.h>

#if DEBUG
#define D(x) dprintf x
#else
#define D(x)
#endif

/* ----------
	zero_open - called on each open().
----- */

static long
zero_open (device_info *dev, ulong flags)
{
	D(("someone opened %s\n", dev ? dev->entry->name : "zero"));

	return B_NO_ERROR;
}


/* ----------
	zero_close
----- */

static long
zero_close (device_info *dev)
{
	D(("%s closed\n", dev ? dev->entry->name : "zero"));

	return B_NO_ERROR;
}


/* ----------
	zero_read - read some stuff from our device.  
	This version tries to make sure the bits returned are truely zero.
	Since there's no way to get input in, this is likely to block infinitely
	_often_ unless something else uses uzero at the same time.
----- */

static long
zero_read (device_info *dev, void *buf, ulong count, ulong pos)
{
	memset((char *)buf, 0, count);
	
	return count;
}

/* ----------
	zero_write - write some stuff to our device.  We ignore the 'pos'
	argument, as the skel is not a positionable device.
----- */

static long
zero_write (device_info *dev, void *buf, ulong count, ulong pos)
{
	return count;
}


/* ----------
	zero_control
----- */

static long
zero_control (device_info *dev, ulong msg, void *buf)
{
	return B_NO_ERROR;
}

/* -----
	driver-related structures
----- */

extern device_entry	devices[] = {
	{
		"/dev/zero",	/* name */
		zero_open, 		/* -> open entry point */
		zero_close, 		/* -> close entry point */
		zero_control, 	/* -> control entry point */
		zero_read,		/* -> read entry point */
		zero_write		/* -> write entry point */
	},
	0
};
