#!/usr/bin/perl

# perfreview - review 'daemon' for Perforce changes.
#
# Uses 'p4 review' to dish up changes for review,
# 'p4 reviews' to find out who should review the changes,
# 'p4 describe' to fill out mail to send to users, and
# 'sendmail -t' to deliver the mail.
#
# Sleeps 60 seconds between each batch.

do
{
	# Remember highest numbered change we see, so that we can
	# reset the 'review' counter once all mail is delivered.
	# If we crash, the worst that happens is we'll send the mail
	# again.

	local( $topChange ) = 0;

	#
	# REVIEW - list of changes to review.
	#

	open( REVIEW, "p4 review -t review|" ) || next;

	while( <REVIEW> )
	{
	    #
	    # Format: "Change x user <email> (Full Name)"
	    #

	    local( $change, $user, $email, $fullName ) = 
		/Change (\d*) (\S*) <(\S*)> (\(.*\))/;

	    print "review $change...\n";

	    #
	    # Get list of people who will review this change
	    #

	    local( @reviewers ) = ();

	    open( REVIEWERS, "p4 reviews -c $change|" ) || next;

	    while( <REVIEWERS> )
	    {
		# user <email> (Full Name)

		local( $user2, $email2, $fullName2 ) = 
		    /(\S*) <(\S*)> (\(.*\))/;

		# Use next line if author shouldn't get email, too.
		# next if( $user eq $user2 );

		push( @reviewers, ", " ) if @reviewers;
		push( @reviewers, "$email2 $fullName2" );
	    }

	    close( REVIEWERS );

	    next if ( !@reviewers );

	    # 
	    # Fire up sendmail and formulate header.
	    # -t means "get To: addresses from message".
	    #

	    open( MAIL, "|/usr/sbin/sendmail -t" );
	    #open( MAIL, "|cat" );

	    print MAIL
		"From: $user $fullName\n",
		"Reply-To: $email\n",
		"Subject: PERFORCE change $change for review\n",
		"To: ", join( "", @reviewers ), "\n",
		"\n";

	    open( DESCRIBE, "p4 describe -s $change|" );

	    while( <DESCRIBE> )
	    {
		# don't allow single .'s through
		$_ = "..\n" if( $_ eq ".\n" );
		print MAIL;
	    }

	    close( DESCRIBE );
	    close( MAIL );

	    $topChange = $change;
	}

	#
	# Update counter to reflect changes reviewed.
	#

	system( "p4 review -c $topChange -t review" ) if( $topChange );
}
while sleep(60);

