#!/usr/bin/perl

# Usage: jgrep pattern checkpoint-or-journal-file
#
# This "grep" understands the @ quoting used in journal files, and
# applies the pattern only to the first line of block of lines bound
# together by quoting.  The simple test is to see if a line has paired
# @'s: if not, this is the beginning (or end) of a quote.
#	

$pattern = shift( @ARGV );

$first = 1;

while( <> )
{
	# if this is the first line of a chunk, look for pattern

	$print = ( /$pattern/ ) if( $first );
	print if( $print );

	# If this line has matching @@'s, we don't change first

	$first = 1 - $first if( ! ( split( /@/ ) % 2 ) );
}


