#!/usr/bin/perl
#
# usage: jextract pattern < cp > cpnew
#
# Extract a checkpoint file, including only those records that match
# the following.
#
# db.domain
# db.view
# db.have
# db.integ 	- keep if $3 matches pattern
# db.locks 
# db.rev 		- keep if $3 matches pattern
# db.revcx 	- keep if $4 matches pattern, put $3 into change list
# db.working
# db.change	- keep if $3 in change list
# db.desc 	- keep if $3 in change list
# db.job
# db.jobpend
# db.jobdesc
# db.fix
# db.fixrev
# db.counters	- keep
# db.protect

$pattern = shift( @ARGV );

%keep = ( 
	"@db.integ@", "pat3", 
	"@db.rev@", "pat3", 
	"@db.revcx@", "cx",
	"@db.change@", "change3",
	"@db.desc@", "change3",
	"@db.counters@", "keep"
) ;

$first = 1;

while( <> )
{
	# if this is the first line of a chunk, look for pattern

	if( $first )
	{
	    split;
	    local( $action ) = $keep{ $_[1] };

	    if( $action eq "pat3" )
	    {
		$print = ( $_[2] =~ /$pattern/ );
	    }
	    elsif( $action eq "cx" )
	    {
		$print = ( $_[3] =~ /$pattern/ );
		$changes{ $_[2] } = 1 if $print;
	    }
	    elsif( $action eq "change3" )
	    {
		$print = $changes{ $_[2] };
	    }
	    elsif( $action eq "keep" )
	    {
		$print = 1;
	    }
	    else
	    {
		$print = 0;
	    }
	}

	print if( $print );

	# If this line has matching @@'s, we don't change first

	$first = 1 - $first if( ! ( split( /@/ ) % 2 ) );
}

