#!/usr/bin/perl

# Usage: findfiles.perl [ dir ]
#
# Generate a list of files recursively under 'dir'
# or current directory if no 'dir' given.
#
# For your local OS, modify the definitions at the top
# as appropriate:
#	$SEP		directory path separator
#	$CWD		symbolic name of current directory
#	$PARENT		symbolic name of parent directory

$SEP = "/";
$CWD = ".";
$PARENT = "..";


$dir = defined (@ARGV) ? $ARGV[0] : $CWD ;

& finddir($dir);

sub finddir
{
    local ($dir) = @_;
    # print "@$dir\n";
    opendir (DIR, $dir );
    local (@list) = readdir(DIR);
    foreach (@list)
    {
	(( $_ eq $CWD ) || ($_ eq $PARENT )) && next ;

	if ( -d "$dir$SEP$_")
	{
	    & finddir( "$dir$SEP$_");
	}
	else
	{
	    print "$dir$SEP$_\n";
	}
    }
}
