// ============================================================
//  STEngine.h	1996 Hiroshi Lockheimer
// ============================================================
// 	STE Version 1.0a4

#pragma once

#include <View.h>
#include "STE.h"
#include "STESupport.h"


class STEngine : public BView {
public:
						STEngine(BRect frame, const char *name, BRect textRect,
						 	 	 ConstSTEStylePtr nullStyle, ulong resizeMask = B_FOLLOW_ALL_SIDES, 
							 	 ulong flags = B_WILL_DRAW | B_PULSE_NEEDED | B_FRAME_EVENTS | B_NAVIGABLE);
	virtual				~STEngine();

	virtual void		AttachedToWindow();
	virtual void		Draw(BRect inRect);
	virtual	void		MouseDown(BPoint where);
	virtual	void		MouseMoved(BPoint where, ulong code, 
							   	   BMessage *message);
	virtual	void		WindowActivated(bool state);
	virtual	void		KeyDown(ulong inKey);
	virtual	void		Pulse();
	virtual	void		FrameResized(float width, float height);
	virtual	void		MakeFocus(bool focusState = TRUE);
	virtual void		SetFontRotation(float degrees);
	virtual void		MessageReceived(BMessage *message);
	
	void				SetText(const char* inText, long inLength,
								ConstSTEStyleRangePtr inStyles = NULL);
	virtual void		Insert(const char *inText, long inLength,
							   ConstSTEStyleRangePtr inStyles = NULL);
	virtual void		Delete();
	
	const char*			Text();
	long				TextLength() const;
	void				GetText(char *buffer, long offset, long length) const;
	char				CharAt(long offset) const;
	
	long				CountLines() const;
	long				CurrentLine() const;
	void				GoToLine(long lineNum);
	
	virtual void		Cut();
	virtual void		Copy();
	virtual void		Paste();
	virtual void		Clear();
	void				SelectAll();

	virtual bool		CanPaste();
	virtual bool		CanDrop(BMessage *inMessage);
			
	virtual void		Select(long startOffset, long endOffset);
	void				GetSelection(long *outStart, long *outEnd) const;

	void				SetStyle(ulong inMode, ConstSTEStylePtr inStyle);
	void				GetStyle(long inOffset, STEStylePtr outStyle) const;
	void				SetStyleRange(long startOffset, long endOffset,
									  ConstSTEStyleRangePtr inStyles, bool inRefresh = TRUE);
	STEStyleRangePtr	GetStyleRange(long startOffset, long endOffset,
									  long *outLength = NULL) const;
	bool				IsContinuousStyle(ulong *ioMode, STEStylePtr outStyle) const;
	
	long				OffsetToLine(long offset) const;
	long				PixelToLine(float pixel) const;
	BPoint				OffsetToPoint(long inOffset, float *outHeight = NULL);
	long				PointToOffset(BPoint point); 
	
	void				FindWord(long inOffset, long *outFromOffset, 
							 	 long *outToOffset);
	
	float				GetHeight(long startLine, long endLine);
	
	virtual void		GetHiliteRegion(long startOffset, long endOffset,
										BRegion *outRegion);
										
	virtual void		ScrollToOffset(long inOffset);
	void				ScrollToSelection();

	void				SetTextRect(BRect rect);
	BRect				TextRect() const;
	void				SetTabWidth(float width);
	float				TabWidth() const;
	void				MakeSelectable(bool selectable = TRUE);
	bool				IsSelectable() const;
	void				MakeEditable(bool editable = TRUE);
	bool				IsEditable() const;
	void				SetWordWrap(bool wrap);
	bool				DoesWordWrap() const;
	void				UseOffscreen(color_space colors);
	void				DontUseOffscreen();
	bool				DoesUseOffscreen() const;
	
protected:
	virtual void		HandleBackspace();
	virtual void		HandleArrowKey(ulong inArrowKey);
	virtual void		HandleDelete();
	virtual void		HandlePageKey(ulong inPageKey);
	virtual void		HandleAlphaKey(uchar inAlphaKey);
	
	void				InsertAt(const char *inText, long inLength,
							   	 long inOffset, ConstSTEStyleRangePtr inStyles = NULL);
	void				RemoveRange(long fromOffset, long toOffset);
	
	void				Refresh(long fromOffset, long toOffset, 
								bool erase, bool scroll);
	
	void				RecalLineBreaks(long *startLine, long *endLine);
	virtual long		FindLineBreak(long fromOffset, float *outAscent, 
								  	  float *outDescent, float width);
	
	virtual bool		IsWordBreakChar(uchar inChar);	
	virtual bool		IsLineBreakChar(uchar inChar);
	
	float				StyledWidth(long fromOffset, long length,
									float *outAscent = NULL, float *outDescent = NULL);
	float				ActualTabWidth(float location);
							
	virtual void		DrawLines(long startLine, long endLine, 
							  	  long startOffset = -1, bool erase = FALSE);
	void				DrawSelection(long startOffset, long endOffset);	
	void				DrawCaret(long offset);
	void				InvertCaret();
	void				DragCaret(long offset);
		
	virtual void		TrackDrag(BPoint where);
	virtual void		InitiateDrag();
	virtual	bool		MessageDropped(BMessage *inMessage, BPoint where,
									   BPoint offset);
											
	virtual void		UpdateScrollbars();
		
	virtual void		Activate();
	virtual void		Deactivate();
	
	virtual void		HandleModification();
	
protected:
	STETextBuffer			mText;
	STELineBuffer			mLines;
	STEStyleBuffer			mStyles;
	BRect					mTextRect;
	long					mSelStart;
	long					mSelEnd;
	bool					mCaretVisible;
	double					mCaretTime;
	long					mClickOffset;
	long					mClickCount;
	double					mClickTime;
	long					mDragOffset;
	bool					mDragOwner;
	bool					mActive;
	float					mTabWidth;
	bool					mSelectable;
	bool					mEditable;
	bool					mWrap;
	BBitmap* 				mOffscreen;

	static STEWidthBuffer	sWidths;
};	
