// ============================================================
//  STESupport.h	1996 Hiroshi Lockheimer
// ============================================================
// 	STE Version 1.0a4

#pragma once

#include "STE.h"


class STETextBuffer {
public:
							STETextBuffer();
							~STETextBuffer();
	
	void					InsertText(const char *inText, long inNumItems, long inAtIndex);
	void					RemoveRange(long start, long end);
	
	void					MoveGapTo(long toIndex);
	void					SizeGapTo(long inCount);

	const char*				GetString(long fromOffset, long numChars);
	bool					FindChar(char inChar, long fromIndex, long *ioDelta);

	const char*				Text();
	long					Length() const;
	char					operator[](long index) const;
	
protected:
	long					mExtraCount;	// when realloc()-ing
	long					mItemCount;		// logical count
	char*					mBuffer;		// allocated memory
	long					mBufferCount;	// physical count
	long					mGapIndex;		// gap position
	long					mGapCount;		// gap count
	char*					mScratchBuffer;	// for GetString
	long					mScratchSize;	// scratch size
};

inline long
STETextBuffer::Length() const
	{ return (mItemCount); }

inline char
STETextBuffer::operator[](long index) const
{
	return ( (index < mGapIndex) ? mBuffer[index] : 
								   mBuffer[index + mGapCount] );
}
	
	
template<class T> class STEBuffer {
public:
							STEBuffer(long inExtraCount = 0, 
									  long inCount = 0);
							~STEBuffer();
					
	void					InsertItemsAt(long inNumItems, long inAtIndex, const T *inItem);
	void					RemoveItemsAt(long inNumItems, long inAtIndex);

	long					ItemCount() const;
	
protected:
	long					mExtraCount;	
	long					mItemCount;	
	long					mBufferCount;	
	T*						mBuffer;		
};	

template<class T>
inline long
STEBuffer<T>::ItemCount() const
	{ return (mItemCount); }
	
	
class STEWidthBuffer : public STEBuffer<STEWidthTable> {
public:
							STEWidthBuffer();
							
	float					StringWidth(STETextBuffer &inText, long fromOffset, long length, 
										ConstSTEStylePtr inStyle, BView *inView);
	
	void					InsertTable(STEWidthTablePtr inTable, long index);
	bool					FindTable(const font_name inFont, long *outIndex);
	float					AddToTable(uchar inChar, long index, 
									   ConstSTEStylePtr inStyle, BView *inView);
};


class STELineBuffer : public STEBuffer<STELine>{
public:
							STELineBuffer();
	
	void					InsertLine(STELinePtr inLine, long index);
	void					RemoveLines(long index, long count = 1);
	void					RemoveLineRange(long fromOffset, long toOffset);
	
	long					OffsetToLine(long offset) const;
	long					PixelToLine(float pixel) const; 
	
	void					BumpOrigin(float delta, long index);
	void					BumpOffset(long delta, long index);
		
	long					NumLines() const;
	ConstSTELinePtr			operator[](long index) const;
};

inline long
STELineBuffer::NumLines() const
	{ return (mItemCount - 1); }

inline ConstSTELinePtr
STELineBuffer::operator[](long index) const
	{ return (&mBuffer[index]); }
	

class STEStyleRunDescBuffer : public STEBuffer<STEStyleRunDesc> {
public:
							STEStyleRunDescBuffer();
						
	void					InsertDesc(STEStyleRunDescPtr inDesc, long index);
	void					RemoveDescs(long index, long count = 1);

	long					OffsetToRun(long offset) const;
	void					BumpOffset(long delta, long index);
	
	ConstSTEStyleRunDescPtr	operator[](long index) const;
};

inline ConstSTEStyleRunDescPtr
STEStyleRunDescBuffer::operator[](long index) const
	{ return (&mBuffer[index]); }
	

class STEStyleRecordBuffer : public STEBuffer<STEStyleRecord> {
public:
							STEStyleRecordBuffer();
						
	long					InsertRecord(ConstSTEStylePtr inRecord, BView *inView);
	void					CommitRecord(long index);
	void					RemoveRecord(long index); 
	
	bool					MatchRecord(ConstSTEStylePtr inRecord, long *outIndex);
	
	ConstSTEStyleRecordPtr	operator[](long index) const;
};

inline ConstSTEStyleRecordPtr
STEStyleRecordBuffer::operator[](long index) const
	{ return (&mBuffer[index]); }
	

class STEStyleBuffer {
public:
							STEStyleBuffer(ConstSTEStylePtr inStyle);
	
	void					InvalidateNullStyle();
	bool					IsValidNullStyle() const;
	
	void					SyncNullStyle(long offset);
	void					SetNullStyle(ulong inMode, ConstSTEStylePtr inStyle, 
										 long offset = 0);
	STEStyle				GetNullStyle() const;	
	
	bool					IsContinuousStyle(ulong *ioMode, STEStylePtr outStyle,
											  long fromOffset, long toOffset) const;
	void					SetStyleRange(long fromOffset, long toOffset,
									 	  long textLen, ulong inMode, 
										  ConstSTEStylePtr inStyle, BView *inView);
	void					GetStyle(long inOffset, STEStylePtr outStyle) const;
	STEStyleRangePtr		GetStyleRange(long startOffset, long endOffset) const;
	
	void					RemoveStyleRange(long fromOffset, long toOffset);
	void					RemoveStyles(long index, long count = 1);
	
	long					Iterate(long fromOffset, long length,
									ConstSTEStylePtr *outStyle = NULL,
									float *outAscent = NULL, float *outDescent = NULL) const;	
	
	long					OffsetToRun(long offset) const;
	void					BumpOffset(long delta, long index);
	
	void					SetStyle(ulong mode, ConstSTEStylePtr fromStyle,
									 STEStylePtr toStyle) const;
							
	STEStyleRun				operator[](long index) const;
								
	long					NumRuns() const;
	
	// use these with caution!
	const STEStyleRunDescBuffer&	RunBuffer() const;
	const STEStyleRecordBuffer&		RecordBuffer() const;

protected:
	STEStyleRunDescBuffer	mStyleRunDesc;
	STEStyleRecordBuffer	mStyleRecord;
	bool					mValidNullStyle;
	STEStyle				mNullStyle;
};

inline long
STEStyleBuffer::NumRuns() const
	{ return (mStyleRunDesc.ItemCount()); }

inline const STEStyleRunDescBuffer&
STEStyleBuffer::RunBuffer() const
	{ return (mStyleRunDesc); }
	
inline const STEStyleRecordBuffer&
STEStyleBuffer::RecordBuffer() const
	{ return (mStyleRecord); }
