// ============================================================
//  STE.h	1996 Hiroshi Lockheimer
// ============================================================
// 	STE Version 1.0a4

#pragma once


const ulong	STE_STYLE_TYPE = 'STEs';


enum {
	doFont			= 0x00000001,	// set font
	doSize			= 0x00000002,	// set size
	doShear			= 0x00000004,	// set shear
	doUnderline		= 0x00000008,	// set underline
	doColor			= 0x00000010,	// set color
	doExtra			= 0x00000020,	// set the extra field
	doAll			= 0x0000003F,	// set everything
	addSize			= 0x00010000	// add size value
};


typedef struct STEStyle {
	font_name		font;		// font name
	float			size;		// point size
	float			shear;		// shear degrees
	bool			underline;	// underlined?
	rgb_color		color;		// pen color
	long			extra;		// extra field for your use
} STEStyle, *STEStylePtr;

typedef const STEStyle* ConstSTEStylePtr;


typedef struct STEStyleRun {
	long			offset;		// byte offset of first character of run
	STEStyle		style;		// style info
} STEStyleRun, *STEStyleRunPtr;

typedef const STEStyleRun* ConstSTEStyleRunPtr;


typedef struct STEStyleRange {
	long			count;		// number of style runs
	STEStyleRun		runs[1];	// array of count number of runs
} STEStyleRange, *STEStyleRangePtr;

typedef const STEStyleRange* ConstSTEStyleRangePtr;


typedef struct STEWidthEntry {
	float			width;		// width (escapement) of char
	bool			valid;		// is width valid?
} STEWidthEntry, *STEWidthEntryPtr;


typedef struct STEWidthTable {
	font_name		font;		// font name
	float			factor;		// conversion factor
	STEWidthEntry	table[256];	// width table
} STEWidthTable, *STEWidthTablePtr;


typedef struct STELine {
	long			offset;		// offset of first character of line
	float			origin;		// pixel position of top of line
	float			ascent;		// maximum ascent for line
} STELine, *STELinePtr;

typedef const STELine* ConstSTELinePtr;


typedef struct STEStyleRecord {
	long			refs;		// reference count for this style
	float			ascent;		// ascent for this style
	float			descent;	// descent for this style
	STEStyle		style;		// style info
} STEStyleRecord, *STEStyleRecordPtr;

typedef const STEStyleRecord* ConstSTEStyleRecordPtr;


typedef struct STEStyleRunDesc {
	long			offset;		// byte offset of first character of run
	long			index;		// index of corresponding style record
} STEStyleRunDesc, *STEStyleRunDescPtr;

typedef const STEStyleRunDesc* ConstSTEStyleRunDescPtr;





