#include <Be.h>
#define DEBUG 1
#include <Debug.h>

#include "PrefsSection.h"

#pragma mark-

class SampleWind: public BWindow
{
public:
						SampleWind(BRect frame, char* title);
						~SampleWind(void);
virtual void 			MessageReceived(BMessage *message);
virtual	bool			QuitRequested();

	BCheckBox*			checkBox;
	BTextControl*		textCtrl;
	PrefsSection*		prefs;
//	bool				busy;
};


//*****************************************************
//*****************************************************
SampleWind::SampleWind(BRect frame, char* title):BWindow(frame, title, B_TITLED_WINDOW, B_NOT_ZOOMABLE | B_NOT_MINIMIZABLE | B_NOT_RESIZABLE)
{
		BRect 			r;
		char 			str[256];

	prefs = new  PrefsSection(PS_User, "applications/ACME/PrefsSample");

//	busy = true;

	r = Bounds();
	r.InsetBy(20, 20);
	r.bottom = r.top + 20;
	prefs->FindString("text", str, sizeof(str));
	textCtrl = new BTextControl(r, "", "Text:", str, new BMessage('text'));
	textCtrl->SetDivider(55);
	AddChild(textCtrl);
	textCtrl->MakeFocus();
	
	r.OffsetBy(0, 30);
	checkBox = new BCheckBox(r, "", "Check Box", new BMessage('cbox'));
	checkBox->SetValue(prefs->FindInt32("checkbox"));
	AddChild(checkBox);

	prefs->SetMessage('smpl');
	
//	busy = false;

	Show();	
}

//*****************************************************
//*****************************************************
SampleWind::~SampleWind()
{
	delete prefs;
}
//*****************************************************
//*****************************************************
void 	SampleWind::MessageReceived(BMessage *message)
{
		const char*		entry;

	switch (message->what)
	{
		case 'cbox':
//			if (! busy)
				prefs->WriteInt32("checkbox", checkBox->Value());
		break;
		
		case 'text':
//			if (! busy)
				prefs->WriteString("text", textCtrl->Text());
		break;
		
		case 'smpl':
//			busy = true;
			entry = message->FindString("entry");
			Lock();
			if (entry != NULL)
				if (strcmp(entry, "checkbox") == 0)
				{
					checkBox->SetValue(prefs->FindInt32("checkbox"));
				}
				else
					if (strcmp(entry, "text") == 0)
					{
							char 		str[256];
							
						prefs->FindString("text", str, sizeof(str));
						textCtrl->SetText(str);
					}
			Unlock();
//			busy = false;
		break;
				
		default:
			BWindow::MessageReceived(message);
		break;		
	}
}


//*****************************************************
//*****************************************************
bool 	SampleWind::QuitRequested()
{
	be_app->Quit();
	return(BWindow::QuitRequested());
}


#pragma mark-

class SampleApp: public BApplication
{
public:
						SampleApp(const char* mime):BApplication(mime){};
virtual void 			MessageReceived(BMessage *message);
virtual	bool			QuitRequested();

	SampleWind*			wind;
};


//*****************************************************
//*****************************************************
void 	SampleApp::MessageReceived(BMessage *message)
{
	if (message->what == 'smpl')
		wind->MessageReceived(message);
	else
		BApplication::MessageReceived(message);
}

//*****************************************************
//*****************************************************
bool 	SampleApp::QuitRequested()
{
	return(BApplication::QuitRequested());
}

//*****************************************************
//*****************************************************
void main(void)
{
		SampleApp*			theApp;
		PrefsSection*		prefs;
		char				title[256];
		uint32				index;
		BRect				bounds(10, 30, 180, 120);

	theApp = new SampleApp("application/x-ACME-PrefsSample");		
	prefs = new  PrefsSection(PS_Temp, "applications/ACME/PrefsSample");
	ASSERT(prefs->IsValid());

	index = prefs->FindInt32("index");
	prefs->WriteInt32("index", index + 1);
	sprintf(title, "Sample #%d", index);
	bounds.OffsetBy((index & 0x7) * 50, (index & 0x7) * 50 + ((index >> 3) & 0x7) * 30);
	
	theApp->wind = new SampleWind(bounds, title);
	theApp->Run();

	delete(prefs);					
	delete(theApp);					
}


