/*******************************************************************
 * BarView.cpp
 * written by Steve Sprang
 * Copyright  1997 Digital Dungeon Software
 ******************************************************************/
 
#include "CloseView.h"
#include "BarView.h"

/******************************************************************
 * BarView::BarView()
 *****************************************************************/
BarView::BarView(BRect bounds, bool closable)
	: BView(bounds, "", B_FOLLOW_LEFT | B_FOLLOW_TOP_BOTTOM, B_WILL_DRAW)
{
	if(closable) { // want a close box?
		BRect closebox = kBOXSIZE;
		closebox.OffsetBy(2,2);
		c = new CloseView(closebox);
		AddChild(c);
	}
	
	this->bounds = bounds;
	
	// reduce flicker
	SetViewColor(kBARBGCOLOR);
}

/******************************************************************
 * BarView::Draw()
 *****************************************************************/
void BarView::Draw(BRect /* update */)
{
	bounds = Bounds();
	
	// fill in background
	SetHighColor(kBARBGCOLOR);
	FillRect(bounds);
		
	tl.Set(bounds.left, bounds.top);
	tr.Set(bounds.right, bounds.top);
	bl.Set(bounds.left, bounds.bottom);
	br.Set(bounds.right, bounds.bottom);
	
	// create 3D highlights and shadows
	SetHighColor(kBARSHADOW);
	StrokeLine(br, tr);
	StrokeLine(br, bl);
	
	SetHighColor(kBARHIGHLIGHT);
	StrokeLine(tl, tr);
	StrokeLine(tl, bl);
}


/******************************************************************
 * BarView::MouseDown()
 *****************************************************************/
void BarView::MouseDown(BPoint loc)
{	
	Window()->Activate();
	
	start = loc;
	
	// spawn a thread to drag the window
	thread_id tid;
	tid = spawn_thread(drag_entry, "", B_NORMAL_PRIORITY, this);
	resume_thread(tid);
}

/******************************************************************
 * BarView::drag_entry()
 *****************************************************************/
long BarView::drag_entry(void *arg)
{
	return ((BarView *) arg)->DragWindow();
}

/******************************************************************
 * BarView::DragWindow()
 *****************************************************************/
long BarView::DragWindow()
{	
	BPoint cursor;
	ulong buttons;
	
	Window()->Lock();
	// get newest mouseloc
	GetMouse(&cursor, &buttons);
	Window()->Unlock();
	
	while(B_PRIMARY_MOUSE_BUTTON & buttons) { // while hanging on
		Window()->Lock();
		// position the point appropriately
		cursor = ConvertToScreen(cursor);
		cursor -= start;
		// move the window
		Window()->MoveTo(cursor.x, cursor.y);
		// store value for next iteration
		GetMouse(&cursor, &buttons);
		Window()->Unlock();
		snooze(20000); // sleep for a while
	}
}


