// Interface Elements header: IEWindow
// Last modified 17 Feb 1997
// (c) 1997 Attila Mezei
// Do not modify this file!


#ifndef _IEWINDOW_H_
#define _IEWINDOW_H_

#include "IEResourceHandler.h"

extern IEResourceHandler *resourcehandler;


struct ObjectInfo;


struct DependantWindowDesc
{
	DependantWindowDesc(BLooper *blooper);
	
	BLooper *looper;
	BMessenger messenger;
};



class IEWindow : public BWindow
{
public:
	IEWindow(char *windowname);
	~IEWindow(void);

	virtual	bool QuitRequested(void);
	virtual	void Quit(void);
	virtual void MessageReceived(BMessage *message);
	
	virtual void Show(void);	// for non-modals
	virtual long Go(void);		// for modals
	virtual void TransformVariablesToWindow(void);
	virtual void TransformWindowToVariables(void);
	virtual void TransformVariableToView(char *viewname);
	virtual void TransformViewToVariable(char *viewname);
	
	virtual void Exit(long exitvalue=0);
	virtual bool ExitHook(long exitvalue);
	virtual long ExitValue(void);

	BRect GetPosition(char *windowname);
	window_type GetType(char *windowname);
	ulong GetFlags(char *windowname);
	char *GetTitle(char *windowname);

	void SetViewVariable(char *viewname, void *variable);
	
	void AddDependantWindow(BWindow *window);

protected:
	BList *dependancy_list;		// of DependantWindowDesc's

private:
	
	char *name;
	IEResourceHandler *rsrc;
	bool modalwindow;
	long exit_value;
		
	BList *viewlist;
};


#endif