//	Test.cc

#include "Infinitas.h"

enum
{
	MY_MESSAGE = 'MMMM'
};

class TestApp : public BApplication
{
	public:
		TestApp();
		void ReadyToRun();
		void MessageReceived(BMessage *);
};

class TestWindow : public Infinitas
{
	public:
		TestWindow(BRect,rgb_color);
		bool QuitRequested();
		void Minimize(bool);
		void Zoom(BPoint,float,float);
};

class ColorWindow : public BWindow
{
	private:
		BColorControl *control;
	public:
		ColorWindow(BPoint);
		bool QuitRequested();
};

class ColorView : public BColorControl
{
	public:
		ColorView(BPoint);
		void AttachedToWindow();
};

main()
{
	TestApp *app = new TestApp();
	app->Run();
	delete app;
}

TestApp::TestApp()
	: BApplication('TTTT')
{
}

void TestApp::ReadyToRun()
{

	BWindow *window = new ColorWindow(BPoint(100,100));
	window->Show();
}

void TestApp::MessageReceived(BMessage *message)
{
	if (message->what == MY_MESSAGE)
	{
		long length;
		rgb_color *color;
		message->PrintToStream();
		color = (rgb_color *)message->FindData("color",B_RGB_COLOR_TYPE,&length);
		BWindow *window = new TestWindow(BRect(100,100,300,200),*color);
		window->Show();
	}
	BApplication::MessageReceived(message);
}

TestWindow::TestWindow(BRect bounds, rgb_color baseColor)
	: Infinitas(bounds,"Infinitas",baseColor,0)
{
}

bool TestWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

void TestWindow::Minimize(bool doMinimize)
{
	WindowShade(doMinimize);
}

void TestWindow::Zoom(BPoint where, float width, float height)
{
	Flip(where,width,height);
}

ColorWindow::ColorWindow(BPoint where)
	: BWindow(BRect(where,where),"Select Color",B_TITLED_WINDOW,0)
{
	control = new ColorView(BPoint(0,0));
	AddChild(control);
}

bool ColorWindow::QuitRequested()
{
	rgb_color color = control->ValueAsColor();
	BMessage *message = new BMessage(MY_MESSAGE);
	message->AddData("color",B_RGB_COLOR_TYPE,&color,sizeof(color));
	be_app->PostMessage(message);
	return true;
}

ColorView::ColorView(BPoint where)
	: BColorControl(where,B_CELLS_16x16,8,NULL)
{
}

void ColorView::AttachedToWindow()
{
	BColorControl::AttachedToWindow();
	Window()->ResizeTo(Bounds().Width(),Bounds().Height());
}