//	ShadowColors.cc

#include "ShadowColors.h"

ShadowColors::ShadowColors(rgb_color baseColor)
	: BObject()
{
	normal = baseColor;
	light.red = (0xFF+2*baseColor.red)/3;
	light.green = (0xFF+2*baseColor.green)/3;
	light.blue = (0xFF+2*baseColor.blue)/3;
	light.alpha = 0xFF;
	lighter.red = (2*0xFF+baseColor.red)/3;
	lighter.green = (2*0xFF+baseColor.green)/3;
	lighter.blue = (2*0xFF+baseColor.blue)/3;
	lighter.alpha = 0xFF;
	dark.red = 2*baseColor.red/3;
	dark.green = 2*baseColor.green/3;
	dark.blue = 2*baseColor.blue/3;
	dark.alpha = 0xFF;
	darker.red = baseColor.red/3;
	darker.green = baseColor.green/3;
	darker.blue = baseColor.blue/3;
	darker.alpha = 0xFF;
}