//	ResInfinitatis.h

#pragma once

#include "PushButton.h"
#include "ShadowColors.h"

enum
{
	RI_TITLEBAR_BOX_MARGIN = 7
};

class TitleBarInfinitatis : public BView
{
	friend class Infinitas;
	friend class TitleBarFilter;
	friend class CloseBoxInfinitatis;
	friend class ZoomBoxInfinitatis;
	
	private:
	
		ShadowColors *colors;
		bool flags;
		bool isMinimized;
		bool isHorizontal;
		ulong clicks;
		BView *closeBox;
		BView *zoomBox;
		
		static long threadProc(void *);
		
		void adjustCloseBox();
		void adjustZoomBox();
		
	public:
		
		TitleBarInfinitatis(const char *,rgb_color,ulong,bool);
		~TitleBarInfinitatis();
		
		void AttachedToWindow();
		void Draw(BRect);
		void FrameResized(float,float);
		void MouseDown(BPoint);
};

class TitleBarFilter : public BMessageFilter
{
	private:
	
		TitleBarInfinitatis *titleBar;
	public:
	
		TitleBarFilter(TitleBarInfinitatis *);
		
		filter_result Filter(BMessage *,BHandler **);
};

class GrowBoxInfinitatis : public BView
{
	private:
	
		ShadowColors *colors;
		ulong flags;
		
		static long threadProc(void *);
		
	public:
	
		GrowBoxInfinitatis(float,rgb_color,ulong);
		
		void AttachedToWindow();
		void Draw(BRect);
		void MouseDown(BPoint);
};

class ZoomBoxInfinitatis : public PushButton
{
	private:
	
		ShadowColors *colors;
		
		void calcPics();
		
	public:
	
		ZoomBoxInfinitatis();
		
		void AttachedToWindow();
		void FrameResized(float,float);
};

class CloseBoxInfinitatis : public PushButton
{
	private:
	
		ShadowColors *colors;
		
		void calcPics();
		
	public:
	
		CloseBoxInfinitatis();
		
		void AttachedToWindow();
		void FrameResized(float,float);
};