//	ResInfinitatis.cc

#include "ResInfinitatis.h"

TitleBarInfinitatis::TitleBarInfinitatis(const char *title, rgb_color baseColor, ulong windowFlags, bool horizontal)
	: BView(BRect(),title,B_FOLLOW_LEFT | B_FOLLOW_RIGHT,B_WILL_DRAW | B_FRAME_EVENTS | B_FULL_UPDATE_ON_RESIZE)
{
	colors = new ShadowColors(baseColor);
	flags = windowFlags;
	isMinimized = false;
	isHorizontal = horizontal;
	SetFontName("Erich");
	SetViewColor(colors->normal);
	SetLowColor(colors->normal);
	if (flags & B_NOT_CLOSABLE)
		closeBox = NULL;
	else
	{
		closeBox = new CloseBoxInfinitatis();
		AddChild(closeBox);
	}
	if (flags & B_NOT_ZOOMABLE)	
		zoomBox = NULL;
	else
	{
		zoomBox = new ZoomBoxInfinitatis();
		AddChild(zoomBox);
	}
}

TitleBarInfinitatis::~TitleBarInfinitatis()
{
	delete colors;
}

void TitleBarInfinitatis::adjustCloseBox()
{
	if (closeBox)
		if (isHorizontal)
		{
			float height = Bounds().Height();
			closeBox->ResizeTo(height-4,height-4);
			closeBox->MoveTo(RI_TITLEBAR_BOX_MARGIN,2);
		}
		else
		{
			float width = Bounds().Width();
			closeBox->ResizeTo(width-4,width-4);
			closeBox->MoveTo(2,RI_TITLEBAR_BOX_MARGIN);
		}
}

void TitleBarInfinitatis::adjustZoomBox()
{
	if (zoomBox)
		if (isHorizontal)
		{
			float height = Bounds().Height();
			zoomBox->ResizeTo(height-4,height-4);
			zoomBox->MoveTo(4+Bounds().Width()-RI_TITLEBAR_BOX_MARGIN-height,2);
		}
		else
		{
			float width = Bounds().Width();
			zoomBox->ResizeTo(width-4,width-4);
			zoomBox->MoveTo(2,4+Bounds().Height()-RI_TITLEBAR_BOX_MARGIN-width);
		}
}

void TitleBarInfinitatis::AttachedToWindow()
{
	Window()->Lock();
	Window()->AddCommonFilter(new TitleBarFilter(this));
	Window()->Unlock();
}

void TitleBarInfinitatis::Draw(BRect clipRect)
{
	rgb_color color;
	BRect box = Bounds();
	box.InsetBy(3,3);
	SetHighColor(colors->dark);
	if (isHorizontal)
		for (long y = box.top; y <= box.bottom; y += 2)
			StrokeLine(BPoint(box.left,y),BPoint(box.right,y),B_MIXED_COLORS);
	else
		for (long x = box.left; x <= box.right; x += 2)
			StrokeLine(BPoint(x,box.top),BPoint(x,box.bottom),B_MIXED_COLORS);
	if (Name() && isHorizontal)
	{
		float start = (Bounds().Width()-StringWidth(Name()))/2;
		box.left = start-2;
		box.right = box.left+StringWidth(Name())+2;
		SetHighColor(colors->normal);
		FillRect(box);
		color.red = 0x00;
		color.blue = 0x00;
		color.green = 0x00;
		color.alpha = 0xFF;
		SetHighColor(color);
		font_info fontInfo;
		GetFontInfo(&fontInfo);
		BPoint where(start,fontInfo.ascent);
		DrawString(Name(),where);
	}
	box = Bounds();
	color.red = (colors->dark.red+colors->darker.red)/2;
	color.blue = (colors->dark.blue+colors->darker.blue)/2;
	color.green = (colors->dark.green+colors->darker.green)/2;
	color.alpha = 0xFF;
	SetHighColor(color);
	StrokeLine(box.RightTop(),box.RightBottom());
	StrokeLine(box.LeftBottom(),box.RightBottom());
	SetHighColor(colors->lighter);
	StrokeLine(box.LeftTop(),box.RightTop());
	StrokeLine(box.LeftTop(),box.LeftBottom());
}

long TitleBarInfinitatis::threadProc(void *object)
{
	TitleBarInfinitatis *titleBar = (TitleBarInfinitatis *)object;
	if (!(titleBar->flags & B_NOT_MINIMIZABLE) && !(titleBar->clicks % 2))
	{
		BMessage *message = new BMessage(B_MINIMIZE);
		message->AddDouble("when",system_time());
		message->AddBool("minimize",!titleBar->isMinimized);
		titleBar->Window()->Lock();
		titleBar->Window()->PostMessage(message);
		titleBar->Window()->Unlock();
	}
	if (!(titleBar->flags & B_NOT_MOVABLE))
	{
		ulong buttons;
		BPoint point, diff, grabPt;
		titleBar->Window()->Lock();
		titleBar->GetMouse(&grabPt,&buttons);
		titleBar->Window()->Unlock();
		while (buttons)
		{
			snooze(20000);
			titleBar->Window()->Lock();
			titleBar->GetMouse(&point,&buttons);
			diff = point-grabPt;
			titleBar->Window()->MoveBy(diff.x,diff.y);
			titleBar->Window()->Unlock();
		}
	}
	return 0;
}

void TitleBarInfinitatis::FrameResized(float width, float height)
{
	adjustCloseBox();
	adjustZoomBox();
}

void TitleBarInfinitatis::MouseDown(BPoint where)
{
	BMessage *message = Window()->CurrentMessage();
	clicks = message->FindLong("clicks");
	thread_id thread = spawn_thread(&threadProc,"title_bar_thread",B_NORMAL_PRIORITY,this);
	resume_thread(thread);
}

TitleBarFilter::TitleBarFilter(TitleBarInfinitatis *bar)
	: BMessageFilter(B_ANY_DELIVERY,B_ANY_SOURCE,B_MINIMIZE)
{
	titleBar = bar;
}

filter_result TitleBarFilter::Filter(BMessage *message, BHandler **handler)
{
	bool doMinimize = message->FindBool("minimize");
	titleBar->isMinimized = doMinimize;
	return B_DISPATCH_MESSAGE;
}

GrowBoxInfinitatis::GrowBoxInfinitatis(float width, rgb_color baseColor, ulong windowFlags)
	: BView(BRect(0,0,width,width),NULL,B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM,B_WILL_DRAW)
{
	colors = new ShadowColors(baseColor);
	flags = windowFlags;
}

void GrowBoxInfinitatis::AttachedToWindow()
{
	BRect box = Bounds();
	BRect bounds = Window()->Bounds();
	MoveTo(1+bounds.right-box.Width(),1+bounds.bottom-box.Height());
}

void GrowBoxInfinitatis::Draw(BRect clipRect)
{
	BRect box = Bounds();
	rgb_color color;
	color.red = (colors->dark.red+colors->darker.red)/2;
	color.blue = (colors->dark.blue+colors->darker.blue)/2;
	color.green = (colors->dark.green+colors->darker.green)/2;
	color.alpha = 0xFF;
	SetHighColor(color);
	StrokeRect(box);
	box.InsetBy(1,1);
	SetHighColor(colors->normal);
	FillRect(box);
	box.InsetBy(1,1);
	SetHighColor(colors->lighter);
	StrokeLine(box.RightTop(),box.RightBottom());
	StrokeLine(box.LeftBottom(),box.RightBottom());
	SetHighColor(colors->darker);
	BPoint point(box.right-1,box.top);
	StrokeLine(box.RightTop(),point);
	point.Set(box.left,box.bottom-1);
	StrokeLine(box.LeftBottom(),point);
	box.right--;
	box.bottom--;
	StrokeLine(box.RightTop(),box.RightBottom());
	StrokeLine(box.LeftBottom(),box.RightBottom());
}

long GrowBoxInfinitatis::threadProc(void *object)
{
	ulong buttons;
	BPoint offset, point, corner, diff;
	GrowBoxInfinitatis *growBox = (GrowBoxInfinitatis *)object;
	BWindow *window = growBox->Window();
	window->Lock();
	growBox->GetMouse(&offset,&buttons);
	window->Unlock();
	do
	{
		snooze(30000);
		window->Lock();
		growBox->GetMouse(&point,&buttons);
		growBox->ConvertToScreen(&point);
		corner = growBox->ConvertToScreen(growBox->Bounds().LeftTop());
		diff = point-offset-corner;
		if (growBox->flags & B_NOT_H_RESIZABLE)
			diff.x = 0;
		if (growBox->flags & B_NOT_V_RESIZABLE)
			diff.y = 0;
		window->ResizeBy(diff.x,diff.y);
		window->Unlock();
	}
	while (buttons);
	return 0;
}

void GrowBoxInfinitatis::MouseDown(BPoint where)
{
	thread_id thread = spawn_thread(&threadProc,"grow_box_thread",B_URGENT_PRIORITY,this);
	resume_thread(thread);
}

ZoomBoxInfinitatis::ZoomBoxInfinitatis()
	: PushButton(BRect(),NULL,NULL,NULL,new BMessage(B_ZOOM),B_FOLLOW_NONE,B_WILL_DRAW | B_FRAME_EVENTS)
{
	colors = NULL;
}

void ZoomBoxInfinitatis::calcPics()
{
	if (colors)
	{
		BPicture *picture = new BPicture;
		BeginPicture(picture);
		BRect box = Bounds();
		box.InsetBy(1,1);
		SetHighColor(colors->darker);
		StrokeLine(box.LeftTop(),box.LeftBottom());
		StrokeLine(box.LeftTop(),box.RightTop());
		box.left++;
		box.top++;
		SetHighColor(colors->lighter);
		StrokeRect(box);
		box.InsetBy(1,1);
		rgb_color color;
		color.red = (colors->normal.red+colors->dark.red)/2;
		color.blue = (colors->normal.blue+colors->dark.blue)/2;
		color.green = (colors->normal.green+colors->dark.green)/2;
		color.alpha = 0xFF;
		SetHighColor(color);
		FillRect(box);
		SetHighColor(colors->darker);
		StrokeLine(box.RightTop(),box.RightBottom());
		StrokeLine(box.LeftBottom(),box.RightBottom());
		box.right -= (1+box.Width()/2);
		box.bottom -= (1+box.Height()/2);
		StrokeLine(box.RightTop(),box.RightBottom());
		StrokeLine(box.LeftBottom(),box.RightBottom());		
		EndPicture();
		SetOffPicture(picture);
		picture = new BPicture;
		BeginPicture(picture);
		box = Bounds();
		box.InsetBy(1,1);
		SetHighColor(colors->darker);
		StrokeRect(box);
		box.InsetBy(2,2);
		StrokeLine(box.LeftTop(),box.RightBottom());
		StrokeLine(box.LeftBottom(),box.RightTop());
		EndPicture();
		SetOnPicture(picture);
	}
}

void ZoomBoxInfinitatis::AttachedToWindow()
{
	PushButton::AttachedToWindow();
	SetTarget(Window());
	TitleBarInfinitatis *titleBar = cast_as(Parent(),TitleBarInfinitatis);
	if (titleBar)
	{
		colors = titleBar->colors;
		SetViewColor(colors->normal);
	}
	calcPics();
}

void ZoomBoxInfinitatis::FrameResized(float width, float height)
{
	calcPics();
}
	
CloseBoxInfinitatis::CloseBoxInfinitatis()
	: PushButton(BRect(),NULL,NULL,NULL,new BMessage(B_QUIT_REQUESTED),B_FOLLOW_NONE,B_WILL_DRAW | B_FRAME_EVENTS)
{
	colors = NULL;
}

void CloseBoxInfinitatis::calcPics()
{
	if (colors)
	{
		BPicture *picture = new BPicture;
		BeginPicture(picture);
		BRect box = Bounds();
		box.InsetBy(1,1);
		SetHighColor(colors->darker);
		StrokeLine(box.LeftTop(),box.LeftBottom());
		StrokeLine(box.LeftTop(),box.RightTop());
		box.left++;
		box.top++;
		SetHighColor(colors->lighter);
		StrokeRect(box);
		box.InsetBy(1,1);
		rgb_color color;
		color.red = (colors->normal.red+colors->dark.red)/2;
		color.blue = (colors->normal.blue+colors->dark.blue)/2;
		color.green = (colors->normal.green+colors->dark.green)/2;
		color.alpha = 0xFF;
		SetHighColor(color);
		FillRect(box);
		SetHighColor(colors->darker);
		StrokeLine(box.RightTop(),box.RightBottom());
		StrokeLine(box.LeftBottom(),box.RightBottom());
		EndPicture();
		SetOffPicture(picture);
		picture = new BPicture;
		BeginPicture(picture);
		box = Bounds();
		box.InsetBy(1,1);
		SetHighColor(colors->darker);
		StrokeRect(box);
		box.InsetBy(2,2);
		StrokeLine(box.LeftTop(),box.RightBottom());
		StrokeLine(box.LeftBottom(),box.RightTop());
		EndPicture();
		SetOnPicture(picture);
	}
}

void CloseBoxInfinitatis::AttachedToWindow()
{
	PushButton::AttachedToWindow();
	SetTarget(Window());
	TitleBarInfinitatis *titleBar = cast_as(Parent(),TitleBarInfinitatis);
	if (titleBar)
	{
		colors = titleBar->colors;
		SetViewColor(colors->normal);
	}
	calcPics();
}

void CloseBoxInfinitatis::FrameResized(float width, float height)
{
	calcPics();
}