//	PushButton.cc

#include "PushButton.h"

PushButton::PushButton(BRect bounds, const char *name, BPicture *on, BPicture *off, BMessage *message, ulong resizeMode, ulong flags)
	: BControl(bounds,name,"",message,resizeMode,flags)
{
	onPic = on;
	offPic = off;
}

PushButton::~PushButton()
{
	if (onPic)
		delete onPic;
	if (offPic)
		delete offPic;
}

void PushButton::AttachedToWindow()
{
	BMessageFilter *filter;
	Window()->Lock();
	BList *filterList = Window()->CommonFilterList();
	if (filterList)
		for (long i = 0; i < filterList->CountItems(); i++)
		{
			filter = (BMessageFilter *)filterList->ItemAt(i);
			if (is_kind_of(filter,PushButtonFilter))
				goto skip;
		}
	Window()->AddCommonFilter(new PushButtonFilter());
skip:
	Window()->Unlock();
}

void PushButton::Draw(BRect clipRect)
{
	if (Value() == B_CONTROL_OFF)
	{
		if (offPic)
			DrawPicture(offPic,BPoint(0,0));
	}
	else
	{
		if (onPic)
			DrawPicture(onPic,BPoint(0,0));
	}
}

void PushButton::MouseDown(BPoint where)
{
	SetValue(B_CONTROL_ON);
	Invalidate();
}

void PushButton::MouseMoved(BPoint where, ulong transit, BMessage *dragMsg)
{
	BMessage *message = Looper()->CurrentMessage();
	ulong buttons = message->FindLong("buttons");
	if (buttons && message->Error() == B_NO_ERROR)
	{
		if (Value() != B_CONTROL_OFF && transit == B_EXITED_VIEW)
		{
			SetValue(B_CONTROL_OFF);
			Invalidate();
		}
		else if (Value() == B_CONTROL_OFF && transit == B_ENTERED_VIEW)
		{
			SetValue(B_CONTROL_ON);
			Invalidate();
		}
	}
}

void PushButton::MouseUp(BPoint where)
{
	if (Value() != B_CONTROL_OFF)
	{
		SetValue(B_CONTROL_OFF);
		Invalidate();
		Invoke();
	}
}

void PushButton::SetOnPicture(BPicture *on)
{
	if (Window())
		Window()->Lock();
	delete onPic;
	onPic = on;
	if (Window())
		Window()->Unlock();
	if (Value() != B_CONTROL_OFF)
		Invalidate();
}

void PushButton::SetOffPicture(BPicture *off)
{
	if (Window())
		Window()->Lock();
	delete offPic;
	offPic = off;
	if (Window())
		Window()->Unlock();
	if (Value() == B_CONTROL_OFF)
		Invalidate();
}

PushButtonFilter::PushButtonFilter()
	: BMessageFilter(B_ANY_DELIVERY,B_ANY_SOURCE,B_MOUSE_UP)
{
}

filter_result PushButtonFilter::Filter(BMessage *message, BHandler **handler)
{
	PushButton *button = cast_as(*handler,PushButton);
	if (button)
	{
		BPoint where = message->FindPoint("where");
		button->MouseUp(where);
	}
	return B_DISPATCH_MESSAGE;
}