//	MouseUpView.cc

#include "MouseUpView.h"

MouseUpFilter::MouseUpFilter()
	: BMessageFilter(B_ANY_DELIVERY,B_ANY_SOURCE,B_MOUSE_UP)
{
}

filter_result MouseUpFilter::Filter(BMessage *message, BHandler **target)
{
	MouseUpView *view = cast_as(*target,MouseUpView);
	if (view)
	{
		BPoint where = message->FindPoint("where");
		if (view->Window())
			view->Window()->Lock();
		view->MouseUp(where);
		if (view->Window())
			view->Window()->Unlock();
	}
	return B_DISPATCH_MESSAGE;
}

MouseUpView::MouseUpView(BRect bounds, const char *name, ulong resizeMode, ulong flags)
	: BView(bounds,name,resizeMode,flags)
{
}

void MouseUpView::AttachedToWindow()
{
	Window()->Lock();
	BMessageFilter *filter;
	BList *filterList = Window()->CommonFilterList();
	if (filterList)
		for (long i = 0; i < filterList->CountItems(); i++)
		{
			filter = (BMessageFilter *)filterList->ItemAt(i);
			if (is_kind_of(filter,MouseUpFilter))
				goto bail;
		}
	Window()->AddCommonFilter(new MouseUpFilter());
bail:
	Window()->Unlock();
}