//	Infinitas.cc

#include "Infinitas.h"
#include "ResInfinitatis.h"

Infinitas::Infinitas(BRect bounds, const char *title, rgb_color baseColor, ulong flags, bool horizontal, ulong workspace)
	: BWindow(bounds,title,B_BORDERED_WINDOW,flags,workspace)
{
	titleBar = new TitleBarInfinitatis(title,baseColor,flags,horizontal);
	AddChild(titleBar);
	isHorizontal = horizontal;
	if (!((flags & B_NOT_RESIZABLE) || ((flags & B_NOT_H_RESIZABLE) && (flags & B_NOT_V_RESIZABLE))))
		AddChild(new GrowBoxInfinitatis(I_GROW_BOX_WIDTH,baseColor,flags));
	adjustTitleBar();
}

void Infinitas::adjustTitleBar()
{
	Lock();
	BRect bounds = Bounds();
	if (isHorizontal)
		bounds.bottom = bounds.top+I_TITLEBAR_THICKNESS;
	else
		bounds.right = bounds.left+I_TITLEBAR_THICKNESS;
	titleBar->ResizeTo(bounds.Width(),bounds.Height());
	Unlock();
}

void Infinitas::FrameResized(float width, float height)
{
	adjustTitleBar();
}

BRect Infinitas::Content()
{
	BRect bounds = Bounds();
	if (isHorizontal)
		bounds.top += (I_TITLEBAR_THICKNESS+1);
	else
		bounds.left += (I_TITLEBAR_THICKNESS+1);
	return bounds;
}

void Infinitas::Flip(BPoint where, float width, float height)
{
	isHorizontal = !isHorizontal;
	TitleBarInfinitatis *bar = cast_as(titleBar,TitleBarInfinitatis);
	if (bar)
		bar->isHorizontal = !bar->isHorizontal;
	MoveTo(where);
	ResizeTo(width,height);
}

void Infinitas::WindowShade(bool doClose)
{
	static BRect bounds;
	if (doClose)
	{
		bounds = Bounds();
		ResizeTo(titleBar->Bounds().Width(),titleBar->Bounds().Height());
	}
	else
		ResizeTo(bounds.Width(),bounds.Height());
}