/****************************************************************/
/*																*/
/*	File:		Main.CPP										*/
/*	Copyright:	Robert Craig Woldberg							*/
/*	Discription:												*/
/*		Contins the start up code for the application			*/
/*																*/
/****************************************************************/


#include <Application.h>


static BBitmap* GetIcon	(	BDatabase*	inDatabasePtr,
							long		inCreator,
							long		inType )

{
	BTable*		ptrTable;
	BRecord*	ptrRecord;
	long		theSize;
	record_id	theRecordID;
	void*		ptrData;
	BRect		theRect;
	BQuery*		ptrQuery	= new BQuery ();
	BBitmap*	ptrBitmap	= NULL;
	
	if ( ( ptrQuery != NULL ) && ( inDatabasePtr != NULL ) ) {
		ptrTable = inDatabasePtr->FindTable ( "Icon" );
		if ( ptrTable != NULL ) {
			ptrQuery->AddTable ( ptrTable );
			
			ptrQuery->PushField ( "creator" );
			ptrQuery->PushLong ( inCreator );
			ptrQuery->PushOp ( B_EQ );
			
			ptrQuery->PushField ( "type" );
			ptrQuery->PushLong ( inType );
			ptrQuery->PushOp ( B_EQ );
			
			ptrQuery->PushOp ( B_AND );
				
			if( ptrQuery->Fetch () == B_NO_ERROR ) {
				theRecordID = ptrQuery->RecordIDAt ( 0 );
				ptrRecord = new BRecord ( ptrTable->Database (), theRecordID );
				if ( ptrRecord != NULL ) {
					ptrData = ptrRecord->FindRaw ( "largeBits", &theSize );
					if ( ptrData != NULL ) {
						theRect.Set ( 0, 0, 31, 31 );
						ptrBitmap = new BBitmap ( theRect, B_COLOR_8_BIT );
						if ( ptrBitmap != NULL ) {
							ptrBitmap->SetBits ( ptrData, theSize, 0, B_COLOR_8_BIT );
						}
					}
					delete ptrRecord;
				}
			}
		}
		delete ptrQuery;
	}
	
	return ptrBitmap;
}


static void foo ( void )

{
	BBitmap*	theIcon;
	BBitmap*	theNewIcon;
	BBitmap*	theDarkIcon;
	BRect		theRect;
	long		theCount;
	long		theTotal;
	uchar*		ptrData;
	
	
	theIcon = GetIcon ( boot_volume ().Database (), 0, 0 );
	if ( theIcon != NULL ) {
		theRect.Set ( 0, 0, 31, 31 );
		theNewIcon = new BBitmap ( theRect, B_RGB_32_BIT );
		if ( theNewIcon != NULL ) {
			theNewIcon->SetBits ( theIcon->Bits (), theIcon->BitsLength (), 0, theIcon->ColorSpace () );
			theDarkIcon = new BBitmap ( theRect, B_COLOR_8_BIT );
			if ( theDarkIcon != NULL ) {
				theTotal = theIcon->BitsLength ();
				ptrData = (uchar*)theIcon->Bits ();
				for ( theCount = 0; theCount < theTotal; theCount++ ) {
					if ( *ptrData > 20 ) {
						*ptrData = *ptrData - 20;
					}
					else {
						*ptrData = 0;
					}
					ptrData++;
				}
				theDarkIcon->SetBits ( theNewIcon->Bits (), theNewIcon->BitsLength (), 0, theNewIcon->ColorSpace () );
				delete theDarkIcon;
			}
			delete theIcon;
		}
		delete theIcon;
	}
	
}


int main ( void )

{
	BApplication*	ptrApp;

	ptrApp = new BApplication ( 'TEST' );
	if ( ptrApp != NULL ) {
		foo ();
		delete ptrApp;
	}
	return 0;
}