  //
  //	Filename:	Console.cpp
  //	Author:		Matthew D Moss (mmoss@io.com)
  //	Version:	1.0
  //
  //	Date		Version		Author		Changes
  //	----------	----------	----------	------------------------
  //	960725		1.0			mmoss		File created.
  //


#include <stdarg.h>
#include <stdio.h>
#include <string.h>
//#include <Button.h>
#include <File.h>
#include <ListView.h>
#include <OS.h>
#include <Rect.h>
#include <Roster.h>
#include <ScrollBar.h>
#include <ScrollView.h>
#include <Window.h>
#include "Console.h"


//
//	The Console window should only be deleted during a
//	B_QUIT_REQUESTED if the application is quitting.  Otherwise,
//	any additional action on the Console will go to a since-killed
//	BWindow.  This can be fixed by subclassing and adding the
//	appropriate safety checks.  For now, I'm keeping it simple.
//
//	Because of this current restriction, the BWindow is created
//	without a close box.  The only normal ways to get a
//	B_QUIT_REQUESTED message is then from a window's "close" menu
//	item (which Console doesn't have), or from the application's
//	"quit" item in the main menu.
//
//	The "quit" item should be safe;  however, putting "close" in
//	the main menu would cause problems.
//
//	These quirks should be fixed in a future version.
//


Console::Console()
	: cons(NULL), list(NULL)
{
	BuildWindow();
}


Console::~Console()
{
	//	Don't try to clear() here;  the window and
	//	and it's children are already gone!
}


void
Console::BuildWindow(void)
{
//	BButton*		clrbtn;
	BRect			frame;
	BScrollView*	scroller;
	char			title[ 2*B_OS_NAME_LENGTH ];
	screen_info		screen;
	thread_info		info;
	
	get_screen_info(&screen);
	frame = screen.frame;
	frame.right -= 4;
	frame.bottom -= 4;
	frame.left = frame.right  - 320;
	frame.top  = frame.bottom - 120;

	get_thread_info( find_thread(NULL), &info );
	strcpy(title, info.name);	
	strcat(title, " -=- Console");
	
	cons = new BWindow(frame, title, B_DOCUMENT_WINDOW, B_NOT_CLOSABLE);

	frame = cons->Bounds();
	frame.right -= B_V_SCROLL_BAR_WIDTH;
	frame.bottom -= B_H_SCROLL_BAR_HEIGHT;
//	frame.top += 21;
	
	list = new BListView(frame, "text", B_FOLLOW_ALL);
	scroller = new BScrollView(B_EMPTY_STRING, list, B_FOLLOW_ALL,
								0, TRUE, TRUE, FALSE);

//	frame = cons->Bounds();
//	frame.right -= B_V_SCROLL_BAR_WIDTH;
//	frame.bottom = frame.top + 20;
//	
//	clrbtn = new BButton(frame, B_EMPTY_STRING,
//					"Clear Console", new BMessage('ClrC'),
//					B_FOLLOW_LEFT | B_FOLLOW_RIGHT | B_FOLLOW_TOP);
//						
//	cons->AddChild(clrbtn);
	cons->AddChild(scroller);
	cons->Show();
}


Console&
Console::theConsole(void)
{
	static Console	theConsole;
	return theConsole;
}


void
Console::append(const char* str)
{
	BListView*		list;
	BScrollBar*		vbar;
	long			rmin, rmax;
	
	list = theConsole().list;
	list->Window()->Lock();
	
	list->AddItem((void*) str);
	vbar = ((BScrollView*) list->Parent())->ScrollBar(B_VERTICAL);
	vbar->GetRange(&rmin, &rmax);
	vbar->SetValue(rmax); 
	
	list->Window()->Unlock();
}


/*
void
Console::clear(void)
{
	long		count;
	BListView*	list;
	
	list = theConsole().list;
	list->Window()->Lock();
	
	count = list->CountItems();
	while (count--) {
		free( list->RemoveItem((long) 0) );
	}
	
	list->Window()->Unlock();
}
*/


int printf(const char* format, ...)
{
	static char	buf[B_PAGE_SIZE];
	va_list		arg;
	int			retval;
	
	va_start(arg, format);
	
	retval = vsprintf(buf, format, arg);
	Console::theConsole().append( strdup(buf) );
	
	va_end(arg);
	
	return retval;
}
