/*
 * Benaphore - smarter semaphore
 *
 *  1996, Chris Herborth (chrish@qnx.com)
 *
 * $Id: Benaphore.h,v 1.2 1996/12/08 20:59:28 chrish Exp $
 *
 * Benaphore is a class implementing the "benaphore" idea that Benoit
 * Schillings discussed in the Be Newsletter, Issue #26.
 *
 * A Benaphore is basically a "smart" semaphore that tries to avoid the
 * overhead of aquire_sem() and release_sem() calls by keeping an atomic
 * counter handy.
 *
 */

#include <kernel/OS.h>
#include <support/SupportDefs.h>

#pragma once

class Benaphore
{
public:
	Benaphore( const char *name = "Benaphore" );
	virtual ~Benaphore( void );

	bool isValid( void ) {
		/* BUG: should return false : true instead of these hard-coded  */
		/*      values... can't fix this until Be's headers support the */
		/*      real bool, true, and false keywords.                    */
		return ( ben_sem < B_NO_ERROR ? 0 : 1 );
	}

	void Lock( void );
	void Unlock( void );

private:
	sem_id ben_sem;
	long   atom;
};
