// Benaphore - see benaphore.h for more information
//
//  1996, Chris Herborth (chrish@qnx.com)

#include "Benaphore.h"

// ----------------------------------------------------------------------
// Constructor
Benaphore::Benaphore( const char *name )
{
	atom = 0;
	ben_sem = create_sem( 0, name );
}

// ----------------------------------------------------------------------
// Destructor
Benaphore::~Benaphore( void )
{
	long retval = delete_sem( ben_sem );
}

// ----------------------------------------------------------------------
// Lock or Unlock the Benaphore

void Benaphore::Lock( void )
{
	long prev = atomic_add( &atom, 1 );

	if( prev > 0 ) {
		acquire_sem( ben_sem );
	}
}

void Benaphore::Unlock( void )
{
	long prev = atomic_add( &atom, -1 );

	if( prev > 1 ) {
		release_sem( ben_sem );
	}
}
