/*
    EditWindow.cpp

    Copyright  1997 Levin-Delson Software.  All Rights Reserved.

    $Header: /Bedazzle/dvlp/DbEd/RCS/EditWindow.cpp,v 1.9 1996/12/30 21:53:13 adamld Exp $
*/

#include "EditWindow.h"

// Local Protos.
BMenuBar *createMenuBar( BRect frame, BHandler *handler );


/* EditWindow is used as to allow the user to edit views. 
   It is similar to ListWindow in its interaction with the parent caller.
   The base class does not present anything to the user; it is just for building upon.
*/
EditWindow :: EditWindow( BPoint origin, BHandler *callersHandler,  rgb_color *rgb_color ) : BWindow( BRect( origin.x, origin.y, origin.x + EW_WIDTH_WINDOW, origin.y + EW_HEIGHT_WINDOW ), NULL, B_TITLED_WINDOW, ( B_NOT_CLOSABLE | B_NOT_RESIZABLE | B_NOT_ZOOMABLE | B_WILL_ACCEPT_FIRST_CLICK | B_WILL_FLOAT ) )
{
	status = B_ERROR;
	menuBar = NULL;
	bTextView = NULL;
	
	parentMessenger = new BMessenger( callersHandler );
	if ( NULL != parentMessenger )
	{
		BRect frame = Frame();
		frame.OffsetTo( B_ORIGIN );

		spacingH = EW_SPACING_H;
		spacingV = EW_SPACING_V;
		
		nextH = spacingH;
		nextV = spacingV;
				
		menuBar = createMenuBar( frame, this );
		if ( NULL != menuBar )
		{
			AddChild( menuBar );

			menuBarHeight = 15.0;
			fontCharWidth = 7.0;
			fontCharHeight = 11.0;	

			if ( TRUE == Lock() )
			{
				menuBarHeight = menuBar->Frame().Height();
				Unlock();
			}

			// Create a background BView to provide a colored backdrop; get the default font info.
			background = new BView( BRect( frame.left, menuBarHeight + 1.0, frame.right, frame.bottom ), EW_NAME_BACKGROUND, B_FOLLOW_ALL, B_WILL_DRAW );
			if ( NULL != background )
			{
				font_info fontInfo;

				if ( NULL != rgb_color )
				{
					background->SetViewColor( *rgb_color );
					background->SetLowColor( *rgb_color );
				}
				
				AddChild( background );
				
				if ( TRUE == Lock() )
				{
					background->GetFontInfo( &fontInfo );
					fontCharWidth = background->StringWidth( "M" );
					Unlock();
				}
		
				fontCharHeight = fontInfo.ascent + fontInfo.descent + fontInfo.leading;
	
				InsureOnScreen();

				status = B_NO_ERROR;
			}
		}
		
		isUnchanged = TRUE;
	}
}


void EditWindow :: MessageReceived( BMessage *message )
{
	if ( NULL != message )
	{
		BMessage *bMessage;
		
		switch ( message->what )
		{
			// Menu "Accept" was hit.
			case ( EW_MESSAGEWHAT_MENUACCEPT ):
				// Hide ourselves; parent will tell us to quit or Show().
				if ( FALSE == IsHidden() )
				{
					Hide();
				}
				
				bMessage = new BMessage( LW_MESSAGEWHAT_ACCEPTNEW );
				if ( NULL != bMessage )
				{
					if ( B_NO_ERROR <= bMessage->AddLong( LW_MESSAGEITEM_HANDLER, (long)this ) )
					{
						if ( B_NO_ERROR <= PrepareAccept( bMessage ) )
						{
							SendParent( bMessage );
							bMessage = NULL;
						}
					}
					
					if ( NULL != bMessage )
					{
						delete bMessage;
					}
				}
			break;
			
			// Menu "Accept" was hit.
			case ( EW_MESSAGEWHAT_MENUCANCEL ):
				// Hide ourselves; parent will tell us to quit.
				if ( FALSE == IsHidden() )
				{
					Hide();
				}
				
				bMessage = new BMessage( LW_MESSAGEWHAT_CANCELNEW );
				if ( NULL != bMessage )
				{
					if ( B_NO_ERROR <= bMessage->AddLong( LW_MESSAGEITEM_HANDLER, (long)this ) )
					{
						if ( B_NO_ERROR <= PrepareCancel( bMessage ) )
						{
							SendParent( bMessage );
							bMessage = NULL;
						}
					}
					
					if ( NULL != bMessage )
					{
						delete bMessage;
					}
				}
			break;
			
			// Parent wants to know if we can quit.
			case ( LW_MESSAGEWHAT_CAN_YOU_QUIT ):
				BMessage *replyMessage = new BMessage( LW_MESSAGEWHAT_OK2QUIT );
				if ( NULL != replyMessage )
				{
					if ( B_NO_ERROR <= replyMessage->AddBool( LW_MESSAGEITEM_OK2QUIT, IsUnchanged() ) )
					{
						if ( B_NO_ERROR <= message->SendReply( replyMessage ) )
						{
							replyMessage = NULL;
						}
					}
					
					// Only delete the message if it _wasn't_ sent. */
					if ( NULL != replyMessage )
					{
						delete( replyMessage );
					}
				}
			break;

			case ( LW_MESSAGEWHAT_ACTIVATE ):
				if ( TRUE == IsHidden() )
				{
					Show();
				}
				
				Activate( TRUE );
			break;

			case ( LW_MESSAGEWHAT_QUIT ):
				if ( FALSE == IsHidden() )
				{
					Hide();
				}
				Quit();
			break;
			
			default:
                // If we don't recognize the message, pass it to the parent class.
                BWindow::MessageReceived( message );
			break;
		}
	}
}


/* Add info to message to accompany announcement of "accept the edit".
   A dummy stub, this function is expected to be overridden.
*/
long EditWindow :: PrepareAccept( BMessage *bMessage )
{
	long result = B_ERROR;
	
	if ( NULL != bMessage )
	{
		result = B_NO_ERROR;
	}
	
	return( result );
}


/* Add info to message to accompany announcement of "cancel the edit".
   A dummy stub, this function is expected to be overridden.
*/
long EditWindow :: PrepareCancel( BMessage *bMessage )
{
	long result = B_ERROR;

	if ( NULL != bMessage )
	{
		result = B_NO_ERROR;
	}
	
	return( result );
}


// Insure that window appears on-scren.
void EditWindow :: InsureOnScreen( void )
{
	screen_info screenInfo;
	
	get_screen_info( &screenInfo );

	if ( TRUE == Lock() )
	{
		float minIndent = max( ( Frame().Width() / EW_PERCENTOFWINDOW_MUST_SHOW ), ( 3 * B_V_SCROLL_BAR_WIDTH ) );
		float maxLeft = screenInfo.frame.right - minIndent;
		if ( Frame().left > maxLeft )
		{
			MoveTo( maxLeft, Frame().top );
		}
		
		Unlock();
	}
}


// Adds a menustrip to the window.  The addMenuItem function can be found in ListWindow.cpp.
BMenuBar *createMenuBar( BRect frame, BHandler *handler )
{
	BMenuBar *bMenuBar = NULL;

	bMenuBar = new BMenuBar( frame, EW_NAME_MENUBAR );
	if ( NULL != bMenuBar )
	{
		bool success = FALSE;
		
		if ( B_NO_ERROR <= addMenuItem( bMenuBar, EW_MESSAGEWHAT_MENUACCEPT, EW_LABEL_MENUACCEPT, handler, TRUE ) )
		{
			if ( B_NO_ERROR <= addMenuItem( bMenuBar, EW_MESSAGEWHAT_MENUCANCEL, EW_LABEL_MENUCANCEL, handler, TRUE ) )
			{
				success = TRUE;
			}
		}
		
		if ( false == success )
		{
			delete bMenuBar;
			bMenuBar = NULL;
		}
	}
	
	return ( bMenuBar );
}


