/*
    DbEd.cpp

    Copyright  1997 Levin-Delson Software.  All Rights Reserved.

    $Header: /Bedazzle/dvlp/DbEd/RCS/DbEd.cpp,v 1.8 1997/01/01 22:38:11 adamld Exp $
*/

#include "DbEd.h"

#pragma mark ## MAIN

int main( void )
{
    DbEd *dbed;

    dbed = new DbEd();
    if ( NULL != dbed )
    {
		if ( B_NO_ERROR <= dbed->Status() )
		{
        	dbed->Run();
		}

        delete dbed;
    }
    
    return( 0 );
}


#pragma mark ## APPLICATION

DbEd :: DbEd() : BApplication( DBED_SIGNATURE )
{
	// Create the main window.
	float dockWidth;
	if ( B_ERROR > get_dock_width( &dockWidth ) )
	{
		dockWidth = 100.0;
	}
		
	DbEdWindow *dbedWindow = new DbEdWindow( BRect( dockWidth + 5.0, 30.0, 2 * dockWidth, 60.0 ), this );
	if ( NULL != dbedWindow )
	{
		if ( B_NO_ERROR <= dbedWindow->Status() )
		{
			dbedWindowMessenger = new BMessenger( dbedWindow );
			if ( NULL != dbedWindowMessenger )
			{
				status = B_NO_ERROR;
			}
		}
	}
}


bool DbEd :: QuitRequested( void )
{
	bool result = TRUE;

	// Find out if children can quit.	
	BMessage *replyMessage = NULL;
	if ( B_NO_ERROR <= dbedWindowMessenger->SendMessage( LW_MESSAGEWHAT_CAN_YOU_QUIT, &replyMessage ) )
	{
		if ( ( NULL != replyMessage ) && ( B_NO_REPLY != replyMessage->what ) )
		{
			bool ok2Quit = replyMessage->FindBool( LW_MESSAGEITEM_OK2QUIT );
			if ( B_NO_ERROR <= replyMessage->Error() )
			{
				result = ok2Quit;
			}
		}
	}
	
	// If not, inform the user.
	if ( FALSE == result )
	{
		BAlert *bAlert = new BAlert( "Quit " DBED_NAME_APP, "If you quit " DBED_NAME_APP " now you will\nlose all changes made since you last saved.", "Quit anyway", "Cancel", NULL, B_WIDTH_FROM_WIDEST, B_WARNING_ALERT );
		if ( NULL != bAlert )
		{
			bAlert->SetShortcut( 1L, B_ESCAPE );
			if ( 0L == bAlert->Go() )
			{
				result = TRUE;
			}
		}
	}
	
	// Tell the main window to quit; it'll take case of telling the child windows to close.
	if ( TRUE == result )
	{
		if ( B_NO_ERROR <= dbedWindowMessenger->SendMessage( LW_MESSAGEWHAT_QUIT ) )
		{
			// Can't expect to talk to the window any longer.
			dbedWindowMessenger = NULL;
		}
	}

	return( result );
}


void DbEd :: AboutRequested( void )
{
	BAlert *bAlert = new BAlert( "About " DBED_NAME_APP, "Provides an interface for database editing.\nCopyright  1997 Levin-Delson Software\nemail: aklevin@bix.com\n" DBED_REVISION, "OK" );
	if ( NULL != bAlert )
	{
		(void)bAlert->Go();
	}
}


void DbEd :: VolumeMounted( long volumeID )
{
	BMessage *bMessage = new BMessage( DBED_MESSAGE_VOLUME_MOUNTED );
	if ( NULL != bMessage )
	{
		if ( B_NO_ERROR <= bMessage->AddLong( DBED_MESSAGEITEMNAME_VOLUMEID, volumeID ) )
		{
			if ( B_NO_ERROR <= dbedWindowMessenger->SendMessage( bMessage ) )
			{
				bMessage = NULL;
			}
		}
		
		if ( NULL != bMessage )
		{
			delete bMessage;
		}
	}
}


void DbEd :: VolumeUnmounted( long volumeID )
{
	BMessage *bMessage = new BMessage( DBED_MESSAGE_VOLUME_UNMOUNTED );
	if ( NULL != bMessage )
	{
		if ( B_NO_ERROR <= bMessage->AddLong( DBED_MESSAGEITEMNAME_VOLUMEID, volumeID ) )
		{
			if ( B_NO_ERROR <= dbedWindowMessenger->SendMessage( bMessage ) )
			{
				bMessage = NULL;
			}
		}
		
		if ( NULL != bMessage )
		{
			delete bMessage;
		}
	}
}


void DbEd :: MessageReceived( BMessage *message )
{
	if ( NULL != message )
	{
		switch ( message->what )
		{
			// The main window was closed.  Quit the app.
			case ( LW_MESSAGEWHAT_CHILD_QUIT_REQUESTED ):
				(void)be_app->PostMessage( B_QUIT_REQUESTED );
			break;
			
			default:
				BApplication ::MessageReceived( message );
			break;
		}
	}
} 
