/* ++++++++++
	FILE:	Joystick.cpp
	REVS:	$Revision$
	NAME:	herold
	DATE:	Fri April 19, 1996
	Copyright (c) 1996 by Be Incorporated.  All Rights Reserved.
+++++ */

#include <string.h>
#include <fcntl.h>
#include <unistd.h>

#include "Joystick.h"


/* ----------
	constructor
----- */

BJoystick::BJoystick() :
	fTimestamp(0.0),
	fHorizontal(0),
	fVertical(0),
	fButton1(FALSE),
	fButton2(FALSE)

{

	ffd = -1;
}

/* ----------
	destructor
----- */

BJoystick::~BJoystick()
{
	close(ffd);
}

/* ----------
	open - actually open the device.
----- */

long
BJoystick::Open(const char *portName)
{
	static struct {
		char	*object_name;	/* name for users of this object */
		char	*dev_name;		/* name for the driver */
	} names[4] = {
		{ "Joystick1", "/dev/joystick_1" },
		{ "Joystick2", "/dev/joystick_2" },
		{ "Joystick3", "/dev/joystick_3" },
		{ "Joystick4", "/dev/joystick_4" }
	};
	char	*dev = NULL;
	int		i;
	
	// look for passed name, map to device name
	for (i = 0; !dev && i < sizeof (names) / sizeof (names[0]); i++)
		if (!strcmp (names[i].object_name, portName))
			dev = names[i].dev_name;
	
	if (!dev)									// name not found?
		return B_ERROR;
		
	if (ffd >= 0)								// it's already open
		close(ffd);								// close to reopen

	ffd = open(dev, O_RDWR);					// open the driver
	
	return(ffd);
}

/* ----------
	Close - close the underlying device
----- */

void
BJoystick::Close()
{
	close(ffd);
	ffd = -1;
}

/* ----------
	Update - update the joystick position and button state
----- */

long
BJoystick::Update()
{
	joystick	j;
	
	if (ffd < 0)
		return B_ERROR;
		
	read (ffd, &j, 1);
	fTimestamp = j.timestamp;
	fHorizontal = j.horizontal;
	fVertical = j.vertical;
	fButton1 = j.button1;
	fButton2 = j.button2;
	
	return B_NO_ERROR;
}

