/* ++++++++++
	FILE:	A2D.cpp
	REVS:	$Revision$
	NAME:	herold
	DATE:	Fri April 19, 1996
	Copyright (c) 1996 by Be Incorporated.  All Rights Reserved.
+++++ */

#include <string.h>
#include <fcntl.h>
#include <unistd.h>

#include "A2D.h"


/* ----------
	constructor
----- */

BA2D::BA2D()
{

	ffd = -1;
}

/* ----------
	destructor
----- */

BA2D::~BA2D()
{
	close(ffd);
}

/* ----------
	open - actually open the device.
----- */

long
BA2D::Open(const char *portName)
{
	static struct {
		char	*object_name;	/* name for users of this object */
		char	*dev_name;		/* name for the driver */
	} names[4] = {
		{ "A2D1", "/dev/a2d_1" },
		{ "A2D2", "/dev/a2d_2" },
		{ "A2D3", "/dev/a2d_3" },
		{ "A2D4", "/dev/a2d_4" }
	};
	char	*dev = NULL;
	int		i;
	
	// look for passed name, map to device name
	for (i = 0; !dev && i < sizeof (names) / sizeof (names[0]); i++)
		if (!strcmp (names[i].object_name, portName))
			dev = names[i].dev_name;
	
	if (!dev)								// name not found?
		return B_ERROR;
		
	if (ffd >= 0)							// it's already open
		close(ffd);							// close to reopen

	ffd = open(dev, O_RDWR);				// open the port

	return(ffd);
}

/* ----------
	Close - close the underlying device
----- */

void
BA2D::Close()
{
	close(ffd);
	ffd = -1;
}

/* ----------
	Read - get current digital port value
----- */

long
BA2D::Read(short *buf)
{
	return (ffd >= 0) ? read(ffd, buf, 1) : B_ERROR;
}


