/*****************************************************************************
//
//	File:			3dRadialLight.h
//
//	Description:	Light source localised in one point, with radial rays.
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
*****************************************************************************/

#ifndef _3D_RADIAL_LIGHT_H
#define _3D_RADIAL_LIGHT_H

#ifndef _3D_DEFS_H 
#include "3dDefs.h"
#endif
#ifndef _3D_LIGHT_H
#include "3dLight.h"
#endif

/**************************************
// B3dRadialLight.
/*************************************/

class B3dRadialLight : public B3dLight {

/*************************************
// HIGH-LEVEL API                   */

 public:
	B3dRadialLight(	char		*name,
					B3dWorld	*world,
					float		power,
					RGBAColor	*color,
					B3dVector	*source);
	/* Create a radial light (like a candle), named 'name', in
	   the world 'world' at the position 'source'. The color
	   of the light at a nominal distance of 1.0 will be the
	   color 'color' multiplied by the factor 'power'.
	   */
	virtual ~B3dRadialLight();
};

#endif
