/****************************************************************************
//
//	File:			3dOffView.h
//
//	Description:	Allow to map a 3dCamera view inside an offscreen.
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
*****************************************************************************/

#ifndef _3D_OFF_VIEW_H
#define _3D_OFF_VIEW_H

#ifndef _3D_CHANNEL_H
#include <3dChannel.h>
#endif
#ifndef _BITMAP_H
#include <Bitmap.h>
#endif
#ifndef _3D_CAMERA_H
#include <3dCamera.h>
#endif
#ifndef _3D_UNIVERSE_H
#include <3dUniverse.h>
#endif

/**************************************
// B3dOffView.
/*************************************/

class B3dOffView : public B3dChannel {
	friend void B3dOffView_erase_buffer(void*, camera_buffer*);
	friend void B3dOffView_switch_buffer(void*, camera_buffer*);
	
/*************************************
// HIGH-LEVEL API                   */

 public:
					B3dOffView(	char			*name,
								BRect		frame,
								B3dWorld		*world,
								B3dChannel	*background = 0L);
	/* Create an 3dOffView named 'name', drawing a view of size 'frame' of the
	   world 'world'. The View can use another B3dChannel as background. */

	virtual			~B3dOffView();
	/* The destructor will NOT free the background 3dChannel in any case. This
	   is the responsibility of the application. */

	B3dChannel *		Background();
	void				SetBackground(B3dChannel *background);
	/* Allows you to check and change the B3dChannel this off-screen view is
	   using as the background of the image it is rendering */

/*------------*/

	/* These work just like the cooresponding calls in B3dView */

	B3dWorld			*World();

	void				SetCamera(B3dCamera *camera);	
	B3dCamera			*Camera();

	uint32			RenderFlags();
	void				SetRenderFlags(uint32 flags);

/*-------------*/

/*************************************
// LOW-LEVEL API                    */


/*************************************
// PRIVATE STUFF                    */

 private:
	int32			cur_buffer;
	int32			offview_lock;
	sem_id			offview_sem;
	/* Benaphore */

	BBitmap			*bitmap[2];
	camera_buffer	buffer[2];
	/* bitmap and buffer specs */

	B3dCamera			*camera;
	/* The camera used by the view to create frames */

	B3dChannel		*background;
	/* The channel we use as background, if any */

	B3dWorld			*m_world;
	/* The world we look into */
	
	void			Lock();
	void			Unlock();
};

#endif












